/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.dom;

import com.sun.org.apache.xpath.internal.Expression;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.corext.dom.Selection;

public class SelectionAnalyzer
extends InOrderVisitor {
    private Selection fSelection;
    private boolean fTraverseSelectedNode;
    private Node fLastCoveringNode;
    private List fSelectedNodes;

    public SelectionAnalyzer(Selection selection, boolean traverseSelectedNode) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fTraverseSelectedNode = traverseSelectedNode;
    }

    public boolean hasSelectedNodes() {
        return this.fSelectedNodes != null && !this.fSelectedNodes.isEmpty();
    }

    public Node[] getSelectedNodes() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return new Node[0];
        }
        return this.fSelectedNodes.toArray(new Node[this.fSelectedNodes.size()]);
    }

    public Node getFirstSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (Node)this.fSelectedNodes.get(0);
    }

    public Node getLastSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (Node)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
    }

    public boolean isExpressionSelected() {
        if (!this.hasSelectedNodes()) {
            return false;
        }
        return this.fSelectedNodes.get(0) instanceof Expression;
    }

    public IRegion getSelectedNodeRange() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        Node firstNode = (Node)this.fSelectedNodes.get(0);
        Node lastNode = (Node)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
        int start = firstNode.getPosition().getStartOffset();
        return new Region(start, lastNode.getPosition().getEndOffset() - start);
    }

    public Node getLastCoveringNode() {
        return this.fLastCoveringNode;
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    protected Instruction visitNode(Node node) {
        if (this.fSelection.liesOutside(node)) {
            return null;
        }
        if (this.fSelection.covers(node)) {
            if (this.isFirstNode()) {
                this.handleFirstSelectedNode(node);
            } else {
                this.handleNextSelectedNode(node);
            }
            return null;
        }
        if (this.fSelection.coveredBy(node)) {
            this.fLastCoveringNode = node;
            return null;
        }
        if (this.fSelection.endsIn(node)) {
            this.handleSelectionEndsIn(node);
            return null;
        }
        return null;
    }

    protected void reset() {
        this.fSelectedNodes = null;
    }

    protected void handleFirstSelectedNode(Node node) {
        this.fSelectedNodes = new ArrayList(5);
        this.fSelectedNodes.add(node);
    }

    protected void handleNextSelectedNode(Node node) {
        this.fSelectedNodes.add(node);
    }

    protected boolean handleSelectionEndsIn(Node node) {
        return false;
    }

    protected List internalGetSelectedNodes() {
        return this.fSelectedNodes;
    }

    private boolean isFirstNode() {
        return this.fSelectedNodes == null;
    }
}

