/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.template.ruby;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContext;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContext;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyScriptContextType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyContextType
extends RubyScriptContextType {
    public static final String NAME = "ruby";

    public RubyContextType() {
        super(NAME);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver((TemplateVariableResolver)new File());
        this.addResolver((TemplateVariableResolver)new Path());
        this.addResolver((TemplateVariableResolver)new Class());
        this.addResolver((TemplateVariableResolver)new ClassFullyQualifiedName());
        this.addResolver((TemplateVariableResolver)new Method());
        this.addResolver((TemplateVariableResolver)new MethodFullyQualifiedName());
    }

    public RubyScriptContext createContext(IDocument document, int offset, int length, IRubyScript script) {
        return new RubyContext(this, document, offset, length, script);
    }

    public static class Class
    extends SimpleTemplateVariableResolver {
        public Class() {
            super("class", "Expands to the name of the class surrounding the template expansion location, such as Foo");
        }

        protected String resolve(TemplateContext context) {
            block4: {
                IRubyElement element;
                block5: {
                    if (!(context instanceof RubyScriptContext)) break block4;
                    RubyScriptContext rsContext = (RubyScriptContext)context;
                    IRubyScript script = rsContext.getRubyScript();
                    element = script.getElementAt(rsContext.getStart());
                    if (element != null) break block5;
                    return "";
                }
                try {
                    IType type = null;
                    type = element.isType(5) ? (IType)element : (IType)element.getAncestor(5);
                    if (type != null) {
                        return type.getElementName();
                    }
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            }
            return "";
        }
    }

    public static class ClassFullyQualifiedName
    extends SimpleTemplateVariableResolver {
        public ClassFullyQualifiedName() {
            super("classfqn", "Expands to the fully qualified name of the class surrounding the template expansion location, such as Foo::Bar");
        }

        protected String resolve(TemplateContext context) {
            block4: {
                IRubyElement element;
                block5: {
                    if (!(context instanceof RubyScriptContext)) break block4;
                    RubyScriptContext rsContext = (RubyScriptContext)context;
                    IRubyScript script = rsContext.getRubyScript();
                    element = script.getElementAt(rsContext.getStart());
                    if (element != null) break block5;
                    return "";
                }
                try {
                    IType type = null;
                    type = element.isType(5) ? (IType)element : (IType)element.getAncestor(5);
                    if (type != null) {
                        return type.getFullyQualifiedName();
                    }
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            }
            return "";
        }
    }

    public static class File
    extends SimpleTemplateVariableResolver {
        public File() {
            super("file", "Expands to the current filename, such as foo.rb");
        }

        protected String resolve(TemplateContext context) {
            if (context instanceof RubyScriptContext) {
                RubyScriptContext rsContext = (RubyScriptContext)context;
                IRubyScript script = rsContext.getRubyScript();
                return script.getElementName();
            }
            return "";
        }
    }

    public static class Method
    extends SimpleTemplateVariableResolver {
        public Method() {
            super("method", "Expands to the name of the method surrounding the template expansion location, such as foo");
        }

        protected String resolve(TemplateContext context) {
            block4: {
                IRubyElement element;
                block5: {
                    if (!(context instanceof RubyScriptContext)) break block4;
                    RubyScriptContext rsContext = (RubyScriptContext)context;
                    IRubyScript script = rsContext.getRubyScript();
                    element = script.getElementAt(rsContext.getStart());
                    if (element != null) break block5;
                    return "";
                }
                try {
                    IMethod method = null;
                    method = element.isType(6) ? (IMethod)element : (IMethod)element.getAncestor(6);
                    if (method != null) {
                        return method.getElementName();
                    }
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            }
            return "";
        }
    }

    public static class MethodFullyQualifiedName
    extends SimpleTemplateVariableResolver {
        public MethodFullyQualifiedName() {
            super("methodfqn", "Expands to the fully qualified name of the method surrounding the template expansion location, such as Foo::Bar#foo");
        }

        protected String resolve(TemplateContext context) {
            block5: {
                IRubyElement element;
                block6: {
                    if (!(context instanceof RubyScriptContext)) break block5;
                    RubyScriptContext rsContext = (RubyScriptContext)context;
                    IRubyScript script = rsContext.getRubyScript();
                    element = script.getElementAt(rsContext.getStart());
                    if (element != null) break block6;
                    return "";
                }
                try {
                    IMethod method = null;
                    method = element.isType(6) ? (IMethod)element : (IMethod)element.getAncestor(6);
                    if (method != null) {
                        IType type = method.getDeclaringType();
                        String name = "";
                        if (type != null) {
                            name = String.valueOf(name) + type.getFullyQualifiedName();
                        }
                        name = method.isSingleton() ? String.valueOf(name) + "::" : String.valueOf(name) + "#";
                        name = String.valueOf(name) + method.getElementName();
                        return name;
                    }
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            }
            return "";
        }
    }

    public static class Path
    extends SimpleTemplateVariableResolver {
        public Path() {
            super("path", "Expands to the name of the current full file path, such as /foo/bar.rb");
        }

        protected String resolve(TemplateContext context) {
            if (context instanceof RubyScriptContext) {
                RubyScriptContext rsContext = (RubyScriptContext)context;
                IRubyScript script = rsContext.getRubyScript();
                IPath path = script.getPath();
                if (path.segmentCount() > 0 && path.segment(0).equals(script.getRubyProject().getElementName())) {
                    path = path.removeFirstSegments(1);
                }
                return path.toPortableString();
            }
            return "";
        }
    }
}

