/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;

public class ExternalFileTypeInfo
extends TypeInfo {
    private final String fPath;

    public ExternalFileTypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isModule, String path) {
        super(pkg, name, enclosingTypes, isModule);
        this.fPath = path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!ExternalFileTypeInfo.class.equals(obj.getClass())) {
            return false;
        }
        ExternalFileTypeInfo other = (ExternalFileTypeInfo)obj;
        return this.doEquals(other) && this.fPath.equals(other.fPath);
    }

    public int getElementType() {
        return 2;
    }

    protected IRubyElement getContainer(IRubySearchScope scope) throws RubyModelException {
        IRubyModel jmodel = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IPath[] enclosedPaths = scope.enclosingProjectsAndJars();
        Path filePath = new Path(this.fPath);
        int i = 0;
        while (i < enclosedPaths.length) {
            IPath curr = enclosedPaths[i];
            if (curr.segmentCount() == 1) {
                IRubyProject jproject = jmodel.getRubyProject(curr.segment(0));
                ISourceFolderRoot[] roots = jproject.getSourceFolderRoots();
                int j = 0;
                while (j < roots.length) {
                    ISourceFolderRoot root = roots[j];
                    if (root.isExternal() && root.getPath().isPrefixOf((IPath)filePath)) {
                        IPath relative = filePath.removeFirstSegments(root.getPath().segmentCount());
                        return this.findElementInRoot(root, relative);
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<IPath> paths = Arrays.asList(enclosedPaths);
        IRubyProject[] projects = jmodel.getRubyProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            IRubyProject jproject = projects[i2];
            if (!paths.contains(jproject.getPath())) {
                ISourceFolderRoot[] roots = jproject.getSourceFolderRoots();
                int j = 0;
                while (j < roots.length) {
                    ISourceFolderRoot root = roots[j];
                    if (root.isExternal() && root.getPath().isPrefixOf((IPath)filePath)) {
                        IPath relative = filePath.removeFirstSegments(root.getPath().segmentCount());
                        return this.findElementInRoot(root, relative);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return null;
    }

    private IRubyElement findElementInRoot(ISourceFolderRoot root, IPath relative) {
        ISourceFolder frag = root.getSourceFolder(relative.removeLastSegments(1).segments());
        String extension = this.getExtension();
        String fullName = String.valueOf(this.getFileName()) + '.' + extension;
        if (!RubyCore.isRubyLikeFileName((String)fullName)) {
            return null;
        }
        IRubyScript res = frag.getRubyScript(fullName);
        if (res.exists()) {
            return res;
        }
        return null;
    }

    private String getFileName() {
        String name = new File(this.fPath).getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    private String getExtension() {
        String name = new File(this.fPath).getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public IPath getPackageFragmentRootPath() {
        return new Path(this.fPath);
    }

    public String getPackageFragmentRootName() {
        return this.fPath;
    }

    public String getPath() {
        return this.fPath;
    }

    public long getContainerTimestamp() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(this.fPath);
        IResource resource = root.findMember((IPath)path);
        IFileInfo info = null;
        ISourceFolderRoot element = null;
        if (resource != null && resource.exists()) {
            URI location = resource.getLocationURI();
            if (location != null) {
                try {
                    info = EFS.getStore((URI)location).fetchInfo();
                    if (info.exists() && (element = RubyCore.create((IResource)resource)) != null && !element.exists()) {
                        element = null;
                    }
                }
                catch (CoreException coreException) {}
            }
        } else {
            info = EFS.getLocalFileSystem().getStore(Path.fromOSString((String)this.fPath)).fetchInfo();
            if (info.exists()) {
                element = this.getPackageFragementRootForExternalJar();
            }
        }
        if (info != null && info.exists() && element != null) {
            return info.getLastModified();
        }
        return -1L;
    }

    public boolean isContainerDirty() {
        return false;
    }

    private void getElementPath(StringBuffer result) {
        String pack = this.getPackageName();
        if (pack != null && pack.length() > 0) {
            result.append(pack.replace('.', '/'));
            result.append('/');
        }
        result.append(this.getFileName());
        result.append('.');
        result.append(this.getExtension());
    }

    private ISourceFolderRoot getPackageFragementRootForExternalJar() {
        try {
            IRubyModel jmodel = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IRubyProject[] projects = jmodel.getRubyProjects();
            int i = 0;
            while (i < projects.length) {
                IRubyProject project = projects[i];
                ISourceFolderRoot root = project.getSourceFolderRoot(this.fPath);
                if (project.isOnLoadpath((IRubyElement)root)) {
                    return root;
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return null;
    }
}

