/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.internal.corext.CorextMessages;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIException;
import org.rubypeople.rdt.internal.ui.RubyUIStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class History {
    private static final String DEFAULT_ROOT_NODE_NAME = "histroyRootNode";
    private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
    private static final int MAX_HISTORY_SIZE = 60;
    private final Map fHistory = new LinkedHashMap(80, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 60;
        }
    };
    private final Hashtable fPositions;
    private final String fFileName;
    private final String fRootNodeName;
    private final String fInfoNodeName;

    private static RubyUIException createException(Throwable t, String message) {
        return new RubyUIException(RubyUIStatus.createError(4, message, t));
    }

    public History(String fileName, String rootNodeName, String infoNodeName) {
        this.fFileName = fileName;
        this.fRootNodeName = rootNodeName;
        this.fInfoNodeName = infoNodeName;
        this.fPositions = new Hashtable(60);
    }

    public History(String fileName) {
        this(fileName, DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
    }

    public synchronized void accessed(Object object) {
        this.fHistory.put(this.getKey(object), object);
        this.rebuildPositions();
    }

    public synchronized boolean contains(Object object) {
        return this.fHistory.containsKey(this.getKey(object));
    }

    public synchronized boolean containsKey(Object key) {
        return this.fHistory.containsKey(key);
    }

    public synchronized boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public synchronized Object remove(Object object) {
        Object removed = this.fHistory.remove(this.getKey(object));
        this.rebuildPositions();
        return removed;
    }

    public synchronized Object removeKey(Object key) {
        Object removed = this.fHistory.remove(key);
        this.rebuildPositions();
        return removed;
    }

    public synchronized float getNormalizedPosition(Object key) {
        if (!this.containsKey(key)) {
            return 0.0f;
        }
        int pos = (Integer)this.fPositions.get(key) + 1;
        return (float)pos / (float)this.fHistory.size();
    }

    public synchronized int getPosition(Object key) {
        if (!this.containsKey(key)) {
            return -1;
        }
        return (Integer)this.fPositions.get(key);
    }

    public synchronized void load() {
        IPath stateLocation = RubyPlugin.getDefault().getStateLocation().append(this.fFileName);
        File file = new File(stateLocation.toOSString());
        if (file.exists()) {
            InputStreamReader reader = null;
            try {
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
                    this.load(new InputSource(reader));
                }
                catch (IOException e) {
                    RubyPlugin.log(e);
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e2) {
                        RubyPlugin.log(e2);
                    }
                }
                catch (CoreException e) {
                    RubyPlugin.log(e);
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e3) {
                        RubyPlugin.log(e3);
                    }
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    RubyPlugin.log(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void save() {
        IPath stateLocation = RubyPlugin.getDefault().getStateLocation().append(this.fFileName);
        File file = new File(stateLocation.toOSString());
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                this.save(out);
            }
            catch (IOException e) {
                RubyPlugin.log(e);
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e2) {
                    RubyPlugin.log(e2);
                }
            }
            catch (CoreException e) {
                RubyPlugin.log(e);
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e3) {
                    RubyPlugin.log(e3);
                }
            }
            catch (TransformerFactoryConfigurationError e) {
                RubyPlugin.log(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e4) {
                    RubyPlugin.log(e4);
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                RubyPlugin.log(e);
            }
        }
    }

    protected Set getKeys() {
        return this.fHistory.keySet();
    }

    protected Collection getValues() {
        return this.fHistory.values();
    }

    protected abstract void setAttributes(Object var1, Element var2);

    protected abstract Object createFromElement(Element var1);

    protected abstract Object getKey(Object var1);

    private void rebuildPositions() {
        this.fPositions.clear();
        Collection values = this.fHistory.values();
        int pos = 0;
        for (Object element : values) {
            this.fPositions.put(this.getKey(element), new Integer(pos));
            ++pos;
        }
    }

    private void load(InputSource inputSource) throws CoreException {
        Element root;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            root = parser.parse(inputSource).getDocumentElement();
        }
        catch (SAXException e) {
            throw History.createException(e, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        catch (ParserConfigurationException e) {
            throw History.createException(e, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        catch (IOException e) {
            throw History.createException(e, Messages.format(CorextMessages.History_error_read, this.fFileName));
        }
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.fRootNodeName)) {
            return;
        }
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element type;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (type = (Element)node).getNodeName().equalsIgnoreCase(this.fInfoNodeName)) {
                Object object = this.createFromElement(type);
                this.fHistory.put(this.getKey(object), object);
            }
            ++i;
        }
        this.rebuildPositions();
    }

    private void save(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(this.fRootNodeName);
            document.appendChild(rootElement);
            for (Object object : this.getValues()) {
                Element element = document.createElement(this.fInfoNodeName);
                this.setAttributes(object, element);
                rootElement.appendChild(element);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw History.createException(e, Messages.format(CorextMessages.History_error_serialize, this.fFileName));
        }
        catch (ParserConfigurationException e) {
            throw History.createException(e, Messages.format(CorextMessages.History_error_serialize, this.fFileName));
        }
    }
}

