/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.HashMap;
import java.util.Map;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;

public class MethodOverrideTester {
    private final IType fFocusType;
    private final ITypeHierarchy fHierarchy;
    private Map fMethodSubstitutions;
    private Map fTypeVariableSubstitutions;

    public MethodOverrideTester(IType focusType, ITypeHierarchy hierarchy) {
        this.fFocusType = focusType;
        this.fHierarchy = hierarchy;
        this.fTypeVariableSubstitutions = null;
        this.fMethodSubstitutions = null;
    }

    public IType getFocusType() {
        return this.fFocusType;
    }

    public ITypeHierarchy getTypeHierarchy() {
        return this.fHierarchy;
    }

    public IMethod findDeclaringMethod(IMethod overriding, boolean testVisibility) throws RubyModelException {
        IMethod result = null;
        IMethod overridden = this.findOverriddenMethod(overriding, testVisibility);
        while (overridden != null) {
            result = overridden;
            overridden = this.findOverriddenMethod(result, testVisibility);
        }
        return result;
    }

    public IMethod findOverriddenMethod(IMethod overriding, boolean testVisibility) throws RubyModelException {
        IMethod res;
        if (overriding.getVisibility() == 2 || overriding.isSingleton() || overriding.isConstructor()) {
            return null;
        }
        IType type = overriding.getDeclaringType();
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null && res.getVisibility() != 2 && (!testVisibility || RubyModelUtil.isVisibleInHierarchy((IMember)res, type.getSourceFolder()))) {
            return res;
        }
        if (!overriding.isConstructor()) {
            IType[] interfaces = this.fHierarchy.getSuperModules(type);
            int i = 0;
            while (i < interfaces.length) {
                IMethod res2 = this.findOverriddenMethodInHierarchy(interfaces[i], overriding);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return null;
    }

    public IMethod findOverriddenMethodInHierarchy(IType type, IMethod overriding) throws RubyModelException {
        IMethod res;
        IMethod method = this.findOverriddenMethodInType(type, overriding);
        if (method != null) {
            return method;
        }
        IType superClass = this.fHierarchy.getSuperclass(type);
        if (superClass != null && (res = this.findOverriddenMethodInHierarchy(superClass, overriding)) != null) {
            return res;
        }
        if (!overriding.isConstructor()) {
            IType[] superInterfaces = this.fHierarchy.getSuperModules(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IMethod res2 = this.findOverriddenMethodInHierarchy(superInterfaces[i], overriding);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return method;
    }

    public IMethod findOverriddenMethodInType(IType overriddenType, IMethod overriding) throws RubyModelException {
        IMethod[] overriddenMethods = overriddenType.getMethods();
        int i = 0;
        while (i < overriddenMethods.length) {
            if (this.isSubsignature(overriding, overriddenMethods[i])) {
                return overriddenMethods[i];
            }
            ++i;
        }
        return null;
    }

    public IMethod findOverridingMethodInType(IType overridingType, IMethod overridden) throws RubyModelException {
        IMethod[] overridingMethods = overridingType.getMethods();
        int i = 0;
        while (i < overridingMethods.length) {
            if (this.isSubsignature(overridingMethods[i], overridden)) {
                return overridingMethods[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isSubsignature(IMethod overriding, IMethod overridden) throws RubyModelException {
        if (!overridden.getElementName().equals(overriding.getElementName())) {
            return false;
        }
        int nParameters = overridden.getNumberOfParameters();
        if (nParameters != overriding.getNumberOfParameters()) {
            return false;
        }
        return nParameters == 0;
    }

    private static class Substitutions {
        public static final Substitutions EMPTY_SUBST = new Substitutions();
        private HashMap fMap = null;

        public void addSubstitution(String typeVariable, String substitution, String erasure) {
            if (this.fMap == null) {
                this.fMap = new HashMap(3);
            }
            this.fMap.put(typeVariable, new String[]{substitution, erasure});
        }

        private String[] getSubstArray(String typeVariable) {
            if (this.fMap != null) {
                return (String[])this.fMap.get(typeVariable);
            }
            return null;
        }

        public String getSubstitution(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[0];
            }
            return null;
        }

        public String getErasure(String typeVariable) {
            String[] subst = this.getSubstArray(typeVariable);
            if (subst != null) {
                return subst[1];
            }
            return null;
        }
    }
}

