/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jruby.Ruby;
import org.jruby.ast.CommentNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.runtime.builtin.IRubyObject;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ui.text.HTMLPrinter;
import org.rubypeople.rdt.ui.RubyElementLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDocUtil {
    private static final long LABEL_FLAGS = RubyElementLabels.ALL_FULLY_QUALIFIED | 2L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static Ruby fgRuby;
    private static String fgRdocScriptPath;

    private RDocUtil() {
    }

    public static String getDocumentation(IRubyElement element) {
        if (element instanceof IMember) {
            return RDocUtil.getContents((IMember)element);
        }
        return "";
    }

    public static String getHTMLDocumentation(IRubyElement element) {
        return RDocUtil.getHTMLDocumentation(RDocUtil.getDocumentation(element));
    }

    private static String getContents(IMember member) {
        ISourceRange range;
        int elementOffset;
        String src;
        block6: {
            src = "";
            elementOffset = -1;
            try {
                src = member.getRubyScript().getSource();
                range = member.getSourceRange();
                if (range != null) break block6;
                return null;
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
        }
        elementOffset = range.getOffset();
        Collection<CommentNode> comments = RDocUtil.getComments(src);
        if (member.isType(5) || member.isType(6)) {
            return RDocUtil.getPrecedingComment(comments, elementOffset, src);
        }
        if (member.isType(10) || member.isType(11) || member.isType(12) || member.isType(9)) {
            String comment = RDocUtil.getFollowingComment(comments, elementOffset, src);
            if (comment != null) {
                return comment;
            }
            return RDocUtil.getPrecedingComment(comments, elementOffset, src);
        }
        return RDocUtil.getFollowingComment(comments, elementOffset, src);
    }

    private static String getPrecedingComment(Collection<CommentNode> comments, int elementStart, String src) {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        for (CommentNode comment : comments) {
            String between;
            ISourcePosition pos = comment.getPosition();
            if (pos.getEndOffset() > elementStart || (between = src.substring(pos.getEndOffset(), elementStart)).trim().length() > 0) continue;
            String preceding = RDocUtil.getPrecedingComment(comments, pos.getStartOffset(), src);
            preceding = preceding == null ? RDocUtil.removePrecedingHashes(comment.getContent()) : String.valueOf(preceding) + "\n" + RDocUtil.removePrecedingHashes(comment.getContent());
            return preceding;
        }
        return null;
    }

    private static String getFollowingComment(Collection<CommentNode> comments, int elementStart, String src) {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        for (CommentNode comment : comments) {
            String com;
            String between;
            ISourcePosition pos = comment.getPosition();
            if (pos.getStartOffset() < elementStart || (between = src.substring(elementStart, pos.getStartOffset())).contains("\n") || (com = comment.getContent()) == null || com.length() <= 0) continue;
            return RDocUtil.removePrecedingHashes(com);
        }
        return null;
    }

    private static String removePrecedingHashes(String comment) {
        return comment.trim().substring(1);
    }

    public static String getHTMLDocumentation(String docs) {
        if (docs == null) {
            return null;
        }
        try {
            docs = RDocUtil.removeUnecessaryIndent(docs);
            String script = "require 'rdoc/markup/simple_markup'\nrequire 'rdoc/markup/simple_markup/to_html'\np = SM::SimpleMarkup.new\nh = SM::ToHtml.new\ninput_string =<<EOF\n" + docs + "\nEOF\n" + "p.convert(input_string, h)\n";
            Ruby ruby = RDocUtil.getJRubyInstance();
            ruby.setCurrentDirectory(RDocUtil.getRDocScriptPath());
            IRubyObject object = ruby.evalScriptlet(script);
            docs = object.toString();
        }
        catch (Exception exception) {}
        return docs;
    }

    private static String removeUnecessaryIndent(String docs) {
        int count = 0;
        String[] lines = docs.split("\n");
        if (lines == null || lines.length == 0) {
            return docs;
        }
        String tmp = lines[0];
        if (tmp != null && tmp.length() > 0) {
            while (tmp.charAt(0) == ' ') {
                ++count;
                if (tmp.length() == 1) break;
                tmp = tmp.substring(1);
            }
        }
        StringBuffer modified = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.length() > count && line.substring(0, count).trim().length() == 0) {
                line = line.substring(count);
            }
            modified.append(line);
            modified.append("\n");
            ++i;
        }
        modified.deleteCharAt(modified.length() - 1);
        return modified.toString();
    }

    private static Ruby getJRubyInstance() {
        if (fgRuby == null) {
            fgRuby = Ruby.newInstance();
        }
        return fgRuby;
    }

    private static String getRDocScriptPath() throws IOException {
        if (fgRdocScriptPath == null) {
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc").append("markup").append("simple_markup").append("fragments.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc").append("markup").append("simple_markup").append("inline.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc").append("markup").append("simple_markup").append("lines.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc").append("markup").append("simple_markup").append("to_html.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc").append("markup").append("simple_markup.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("cgi.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("delegate.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("English.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("metadata.rb"));
            RubyCore.copyToStateLocation((Plugin)RubyCore.getPlugin(), (IPath)new Path("ruby").append("rdoc.rb"));
            fgRdocScriptPath = RubyCore.getPlugin().getStateLocation().append("ruby").toPortableString();
        }
        return fgRdocScriptPath;
    }

    public static IRegion getDocumentationRegion(IMember member) {
        if (!member.isType(5) && !member.isType(6)) {
            return null;
        }
        String src = "";
        int elementOffset = -1;
        try {
            src = member.getRubyScript().getSource();
            elementOffset = member.getSourceRange().getOffset();
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
        Collection<CommentNode> comments = RDocUtil.getComments(src);
        return RDocUtil.getPrecedingCommentRegion(comments, elementOffset, src);
    }

    private static Collection<CommentNode> getComments(String src) {
        try {
            RubyParser parser = new RubyParser();
            return parser.parse(src).getCommentNodes();
        }
        catch (SyntaxException syntaxException) {
        }
        catch (Exception e) {
            RubyCore.log((Exception)e);
        }
        return Collections.emptyList();
    }

    private static IRegion getPrecedingCommentRegion(Collection<CommentNode> comments, int elementStart, String src) {
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        for (CommentNode comment : comments) {
            String between;
            ISourcePosition pos = comment.getPosition();
            if (pos.getEndOffset() > elementStart || (between = src.substring(pos.getEndOffset(), elementStart)).trim().length() > 0) continue;
            IRegion preceding = RDocUtil.getPrecedingCommentRegion(comments, pos.getStartOffset(), src);
            preceding = preceding == null ? new Region(pos.getStartOffset(), pos.getEndOffset() - pos.getStartOffset()) : new Region(preceding.getOffset(), pos.getEndOffset() - preceding.getOffset());
            return preceding;
        }
        return null;
    }

    public static String getHTMLDocumentation(IRubyElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        boolean hasContents = false;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList(buffer);
                IRubyElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 12) {
                    HTMLPrinter.addBullet(buffer, RDocUtil.getInfoText(curr));
                    hasContents = true;
                }
                HTMLPrinter.endBulletList(buffer);
                ++i;
            }
        } else {
            IRubyElement curr = result[0];
            if (curr instanceof IMember) {
                IMember member = (IMember)curr;
                String contents = RDocUtil.getHTMLDocumentation((IRubyElement)member);
                if (contents != null) {
                    HTMLPrinter.addSmallHeader(buffer, RDocUtil.getInfoText((IRubyElement)member));
                    HTMLPrinter.addParagraph(buffer, contents);
                }
                hasContents = true;
            } else if (curr != null && curr.getElementType() == 12) {
                HTMLPrinter.addSmallHeader(buffer, RDocUtil.getInfoText(curr));
                hasContents = true;
            }
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String getInfoText(IRubyElement member) {
        long flags = member.getElementType() == 12 ? LOCAL_VARIABLE_FLAGS : LABEL_FLAGS;
        String label = RubyElementLabels.getElementLabel(member, flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

