/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.ExternalFileTypeInfo;
import org.rubypeople.rdt.internal.corext.util.IFileTypeInfo;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;
import org.rubypeople.rdt.internal.corext.util.UnresolvableTypeInfo;

public class TypeInfoFactory {
    private String[] fProjects = TypeInfoFactory.getProjectList();
    private TypeInfo fLast = null;
    private char[] fBuffer = new char[512];
    private static final String RUBY = "rb";

    public TypeInfo create(char[] packageName, char[] typeName, char[][] enclosingName, boolean isModule, String path) {
        path = new Path(path).toPortableString();
        String pn = this.getPackageName(packageName);
        String tn = new String(typeName);
        TypeInfo result = null;
        String project = this.getProject(path);
        result = project != null ? this.createIFileTypeInfo(pn, tn, enclosingName, isModule, path, TypeInfoFactory.getIFileTypeInfo(this.fLast), project) : this.createExternalFileTypeInfo(pn, tn, enclosingName, isModule, path);
        if (result == null) {
            result = new UnresolvableTypeInfo(pn, tn, enclosingName, isModule, path);
        } else {
            this.fLast = result;
        }
        return result;
    }

    private TypeInfo createExternalFileTypeInfo(String packageName, String typeName, char[][] enclosingName, boolean isModule, String path) {
        return new ExternalFileTypeInfo(packageName, typeName, enclosingName, isModule, path);
    }

    private static IFileTypeInfo getIFileTypeInfo(TypeInfo info) {
        if (info == null || info.getElementType() != 3) {
            return null;
        }
        return (IFileTypeInfo)info;
    }

    private TypeInfo createIFileTypeInfo(String packageName, String typeName, char[][] enclosingName, boolean isModule, String path, IFileTypeInfo last, String project) {
        String rest = path.substring(project.length() + 1);
        int index = rest.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        String middle = rest.substring(0, index);
        rest = rest.substring(index + 1);
        index = rest.lastIndexOf(46);
        String file = null;
        String extension = null;
        if (index == -1) {
            return null;
        }
        file = rest.substring(0, index);
        extension = rest.substring(index + 1);
        String src = null;
        int ml = middle.length();
        int pl = packageName.length();
        if (ml > 0 && ml - 1 > pl) {
            src = middle.substring(1, ml - pl - (pl > 0 ? 1 : 0));
        }
        if (last != null && src != null && src.equals(last.getFolder())) {
            src = last.getFolder();
        }
        file = typeName.equals(file) ? typeName : this.createString(file);
        extension = RUBY.equals(extension) ? RUBY : this.createString(extension);
        return new IFileTypeInfo(packageName, typeName, enclosingName, isModule, project, src, file, extension);
    }

    private String getPackageName(char[] packageName) {
        if (this.fLast == null) {
            return new String(packageName);
        }
        String lastPackageName = this.fLast.getPackageName();
        if (Strings.equals(lastPackageName, packageName)) {
            return lastPackageName;
        }
        return new String(packageName);
    }

    private String getProject(String path) {
        int i = 0;
        while (i < this.fProjects.length) {
            String project = this.fProjects[i];
            if (path.startsWith(project, 1)) {
                return project;
            }
            ++i;
        }
        return null;
    }

    private String createString(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length > this.fBuffer.length) {
            this.fBuffer = new char[length];
        }
        s.getChars(0, length, this.fBuffer, 0);
        return new String(this.fBuffer, 0, length);
    }

    private static String[] getProjectList() {
        String[] result;
        IRubyModel model = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IRubyProject[] projects = model.getRubyProjects();
            result = new String[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getElementName();
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {
            result = new String[]{};
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                int l1 = ((String)o1).length();
                if (l1 < (l2 = ((String)o2).length())) {
                    return 1;
                }
                if (l2 < l1) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        return result;
    }
}

