/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.search.RubySearchPageScoreComputer;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;
import org.rubypeople.rdt.ui.RubyUI;

public class EditorInputAdapterFactory
implements IAdapterFactory {
    private static Class[] PROPERTIES = new Class[]{IRubyElement.class};
    private Object fSearchPageScoreComputer;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IRubyElement.class.equals((Object)key) && element instanceof IEditorInput) {
            IRubyScript je = RubyUI.getWorkingCopyManager().getWorkingCopy((IEditorInput)element);
            if (je != null) {
                return je;
            }
            if (element instanceof IStorageEditorInput) {
                try {
                    return ((IStorageEditorInput)element).getStorage().getAdapter(key);
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new RubySearchPageScoreComputer();
        PROPERTIES = new Class[]{ISearchPageScoreComputer.class, IRubyElement.class};
    }
}

