/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IContainmentAdapter;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.RubyCore;

public class RubyElementContainmentAdapter
implements IContainmentAdapter {
    private IRubyModel fRubyModel = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof IRubyElement) || element == null) {
            return false;
        }
        IRubyElement workingSetRubyElement = (IRubyElement)workingSetElement;
        IResource resource = null;
        IRubyElement jElement = null;
        if (element instanceof IRubyElement) {
            jElement = (IRubyElement)element;
            resource = jElement.getResource();
        } else if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && this.fRubyModel.contains(resource) && (jElement = RubyCore.create((IResource)resource)) != null && !jElement.exists()) {
            jElement = null;
        }
        if (jElement != null) {
            if (this.contains(workingSetRubyElement, jElement, flags)) {
                return true;
            }
            if (workingSetRubyElement.getElementType() == 3 && resource.getType() == 2 && this.checkIfDescendant(flags)) {
                return this.isChild(workingSetRubyElement, resource);
            }
        } else if (resource != null) {
            return this.contains(workingSetRubyElement, resource, flags);
        }
        return false;
    }

    private boolean contains(IRubyElement workingSetElement, IRubyElement element, int flags) {
        if (this.checkContext(flags) && workingSetElement.equals(element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetElement.equals(element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    private boolean check(IRubyElement ancestor, IRubyElement descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals(descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean isChild(IRubyElement workingSetElement, IResource element) {
        IResource resource = workingSetElement.getResource();
        if (resource == null) {
            return false;
        }
        return this.check(element, resource);
    }

    private boolean contains(IRubyElement workingSetElement, IResource element, int flags) {
        IResource workingSetResource = workingSetElement.getResource();
        if (workingSetResource == null) {
            return false;
        }
        if (this.checkContext(flags) && workingSetResource.equals((Object)element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetResource.equals((Object)element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetResource, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetResource);
    }

    private boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }

    private boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    private boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    private boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }
}

