/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import java.io.IOException;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyInformation;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.corext.util.OpenTypeHistory;
import org.rubypeople.rdt.internal.corext.util.TypeFilter;
import org.rubypeople.rdt.internal.formatter.OldCodeFormatter;
import org.rubypeople.rdt.internal.ui.AptanaProcessConsoleManager;
import org.rubypeople.rdt.internal.ui.InitializeAfterLoadJob;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyFileMatcher;
import org.rubypeople.rdt.internal.ui.RubyInstalledDetector;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.infoviews.RiUtility;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerPart;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.preferences.MockupPreferenceStore;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.DocumentAdapter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderRegistry;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyEditorTextHoverDescriptor;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemMarkerManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class RubyPlugin
extends AbstractUIPlugin {
    protected static RubyPlugin plugin;
    public static final String PLUGIN_ID = "org.rubypeople.rdt.ui";
    protected RubyTextTools textTools;
    protected RubyFileMatcher rubyFileMatcher;
    private WorkingCopyManager fWorkingCopyManager;
    private RubyDocumentProvider fDocumentProvider;
    protected PropertyResourceBundle pluginProperties;
    private IPreferenceStore fCombinedPreferenceStore;
    private MockupPreferenceStore fMockupPreferenceStore;
    private RubyFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private RubyScriptDocumentProvider fExternalRubyDocumentProvider;
    private RubyEditorTextHoverDescriptor[] fRubyEditorTextHoverDescriptors;
    private TypeFilter fTypeFilter;
    private ProblemMarkerManager fProblemMarkerManager;
    private ASTProvider fASTProvider;
    private ILaunchListener launchListener;
    private RubyExplorerTracker fRubyExplorerTracker;

    public RubyPlugin() {
        plugin = this;
    }

    public MockupPreferenceStore getMockupPreferenceStore() {
        if (this.fMockupPreferenceStore == null) {
            this.fMockupPreferenceStore = new MockupPreferenceStore();
        }
        return this.fMockupPreferenceStore;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        context.registerService(IRubyInformation.class.getName(), (Object)new RiUtility(), null);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(IRubyScript workingCopy) {
                IRubyScript original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.ensurePreferenceStoreBackwardsCompatibility();
        this.launchListener = new AptanaProcessConsoleManager();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
        this.getASTProvider();
        this.fRubyExplorerTracker = new RubyExplorerTracker();
        new InitializeAfterLoadJob().schedule();
    }

    private void ensurePreferenceStoreBackwardsCompatibility() {
        IPreferenceStore store = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(store);
    }

    static void initializeAfterLoad(IProgressMonitor monitor) {
        OpenTypeHistory.getInstance().checkConsistency(monitor);
        new RubyInstalledDetector().schedule();
        RubyPlugin.forceRDTUIPluginToLoad();
    }

    private static void forceRDTUIPluginToLoad() {
        try {
            Bundle bundle = Platform.getBundle((String)"com.aptana.rdt.ui");
            if (bundle == null) {
                return;
            }
            bundle.start();
        }
        catch (Exception exception) {}
    }

    public void stop(BundleContext context) throws Exception {
        try {
            PackageExplorerPart explorer;
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fDocumentProvider != null) {
                this.fDocumentProvider.shutdown();
                this.fDocumentProvider = null;
            }
            if (this.textTools != null) {
                this.textTools.dispose();
                this.textTools = null;
            }
            if (this.fTypeFilter != null) {
                this.fTypeFilter.dispose();
                this.fTypeFilter = null;
            }
            if (this.fMembersOrderPreferenceCache != null) {
                this.fMembersOrderPreferenceCache.dispose();
                this.fMembersOrderPreferenceCache = null;
            }
            if ((explorer = PackageExplorerPart.getFromActivePerspective()) != null) {
                explorer.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fRubyExplorerTracker);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
            this.launchListener = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static void log(String string) {
        RubyPlugin.log(0, string);
    }

    public static RubyPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RubyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(IStatus status) {
        RubyPlugin.getDefault().getLog().log(status);
        System.out.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace();
        }
    }

    public static void log(Throwable e) {
        RubyPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, RubyUIMessages.RdtUiPlugin_internalErrorOccurred, e));
    }

    public static void log(int severity, String message, Throwable e) {
        Status status = new Status(severity, PLUGIN_ID, 0, message, e);
        RubyPlugin.log((IStatus)status);
    }

    public static Shell getActiveWorkbenchShell() {
        return RubyPlugin.getActiveWorkbenchWindow().getShell();
    }

    public synchronized RubyTextTools getRubyTextTools() {
        if (this.textTools == null) {
            this.textTools = new RubyTextTools(this.getPreferenceStore(), RubyCore.getPlugin().getPluginPreferences());
        }
        return this.textTools;
    }

    public OldCodeFormatter getCodeFormatter() {
        return new OldCodeFormatter((Map)RubyCore.getOptions());
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = RubyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public RubyFileMatcher getRubyFileMatcher() {
        if (this.rubyFileMatcher == null) {
            this.rubyFileMatcher = new RubyFileMatcher();
        }
        return this.rubyFileMatcher;
    }

    public IResource getSelectedResource() {
        IStructuredSelection structuredSelection;
        Object obj;
        IWorkbenchPage page = RubyPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return (IResource)obj;
        }
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        IEditorInput input = part.getEditorInput();
        return (IResource)input.getAdapter(IResource.class);
    }

    public boolean isRubyFile(IFile file) {
        return this.getRubyFileMatcher().hasRubyEditorAssociation(file);
    }

    public boolean isRubyFile(IResource resource) {
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        return this.isRubyFile((IFile)resource);
    }

    public WorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            RubyDocumentProvider provider = this.getRubyDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized RubyDocumentProvider getRubyDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new RubyDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized RubyFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new RubyFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(int severity, String string) {
        RubyPlugin.log((IStatus)new Status(severity, PLUGIN_ID, 0, string, null));
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(RubyCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public static void logErrorMessage(String message) {
        RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 10001, message, null));
    }

    public TemplateStore getTemplateStore() {
        return RubyTemplateAccess.getDefault().getTemplateStore();
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        return RubyTemplateAccess.getDefault().getContextTypeRegistry();
    }

    public static boolean isDebug() {
        return RubyPlugin.getDefault().isDebugging();
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return RubyPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }

    public synchronized RubyScriptDocumentProvider getExternalDocumentProvider() {
        if (this.fExternalRubyDocumentProvider == null) {
            this.fExternalRubyDocumentProvider = new RubyScriptDocumentProvider();
        }
        return this.fExternalRubyDocumentProvider;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.pluginProperties == null) {
            try {
                this.pluginProperties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                RubyPlugin.log(e);
            }
        }
        return this.pluginProperties;
    }

    public synchronized TypeFilter getTypeFilter() {
        if (this.fTypeFilter == null) {
            this.fTypeFilter = new TypeFilter();
        }
        return this.fTypeFilter;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public RubyEditorTextHoverDescriptor[] getRubyEditorTextHoverDescriptors() {
        Preferences prefs = this.getPluginPreferences();
        if (prefs != null && !prefs.getBoolean("hovers_enabled")) {
            return new RubyEditorTextHoverDescriptor[0];
        }
        if (this.fRubyEditorTextHoverDescriptors == null) {
            this.fRubyEditorTextHoverDescriptors = RubyEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((RubyEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fRubyEditorTextHoverDescriptors);
            int i = 0;
            while (i < this.fRubyEditorTextHoverDescriptors.length - 1) {
                if ("org.rubypeople.rdt.ui.BestMatchHover".equals(this.fRubyEditorTextHoverDescriptors[i].getId())) {
                    RubyEditorTextHoverDescriptor hoverDescriptor = this.fRubyEditorTextHoverDescriptors[i];
                    int j = i;
                    while (j > 0) {
                        this.fRubyEditorTextHoverDescriptors[j] = this.fRubyEditorTextHoverDescriptors[j - 1];
                        --j;
                    }
                    this.fRubyEditorTextHoverDescriptors[0] = hoverDescriptor;
                    break;
                }
                ++i;
            }
        }
        return this.fRubyEditorTextHoverDescriptors;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public RubyExplorerTracker getProjectTracker() {
        return this.fRubyExplorerTracker;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

