/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyProjectLibraryPage;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

public class RubyProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected RubyProjectLibraryPage projectsPage;
    protected RubyProject workingProject;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.workingProject = this.getRubyProject();
        if (this.workingProject == null || !this.workingProject.getProject().isOpen()) {
            return this.createClosedProjectPageContents(parent);
        }
        return this.createProjectPageContents(parent);
    }

    protected RubyProject getRubyProject() {
        IAdaptable selectedElement = this.getElement();
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof RubyProject) {
            return (RubyProject)selectedElement;
        }
        if (selectedElement instanceof IProject) {
            IProject simpleProject = (IProject)selectedElement;
            try {
                if (simpleProject.hasNature("org.rubypeople.rdt.core.rubynature")) {
                    RubyProject theRubyProject = new RubyProject();
                    theRubyProject.setProject(simpleProject);
                    return theRubyProject;
                }
            }
            catch (CoreException e) {
                RubyPlugin.log(e);
            }
        }
        return null;
    }

    protected Control createClosedProjectPageContents(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(RubyUIMessages.RubyProjectPropertyPage_rubyProjectClosed);
        return label;
    }

    protected Control createProjectPageContents(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.projectsPage = new RubyProjectLibraryPage(this.workingProject);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(RubyUIMessages.RubyProjectLibraryPage_tabName);
        tabItem.setControl(this.projectsPage.getControl((Composite)tabFolder));
        return tabFolder;
    }

    public boolean performOk() {
        try {
            this.projectsPage.getWorkingProject().save(null, true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RubyUIMessages.RubyProjectPropertyPage_performOkException, RubyUIMessages.RubyProjectPropertyPage_performOkExceptionDialogMessage);
        }
        return super.performOk();
    }
}

