/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean isProcessable(Shell shell, IEditorPart editor) {
        if (editor == null) {
            return true;
        }
        IRubyElement input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IRubyElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IRubyElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IRubyElement element) {
        IProject resourceProject;
        block5: {
            if (element.getElementType() == 1) {
                return true;
            }
            IRubyProject project = element.getRubyProject();
            try {
                resourceProject = project.getProject();
                if (resourceProject != null) break block5;
                return false;
            }
            catch (CoreException coreException) {}
        }
        IProjectNature nature = resourceProject.getNature("org.rubypeople.rdt.core.rubynature");
        if (nature != null) {
            return true;
        }
        return false;
    }
}

