/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

public class OpenActionUtil {
    public static void open(Object element, boolean activate) throws RubyModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof IRubyElement) {
            EditorUtility.revealInEditor(part, (IRubyElement)element);
        }
    }

    public static IRubyElement selectRubyElement(IRubyElement[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = RubyElementLabelProvider.SHOW_DEFAULT | 0x40 | 4;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new RubyElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IRubyElement) {
                    return (IRubyElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

