/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTargetList;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.MultiActionGroup;
import org.rubypeople.rdt.internal.ui.actions.SelectAllAction;
import org.rubypeople.rdt.internal.ui.browsing.PackageViewerWrapper;
import org.rubypeople.rdt.internal.ui.browsing.PackagesViewTableViewer;
import org.rubypeople.rdt.internal.ui.browsing.PackagesViewTreeViewer;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingMessages;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.internal.ui.filters.LibraryFilter;
import org.rubypeople.rdt.internal.ui.filters.NonRubyElementFilter;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTableViewer;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.rubypeople.rdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.ui.RubyElementSorter;

public class PackagesView
extends RubyBrowsingPart {
    private static final String TAG_VIEW_STATE = ".viewState";
    private static final int LIST_VIEW_STATE = 0;
    private static final int TREE_VIEW_STATE = 1;
    private SelectAllAction fSelectAllAction;
    private int fCurrViewState;
    private PackageViewerWrapper fWrappedViewer;
    private MultiActionGroup fSwitchActionGroup;
    private boolean fLastInputWasProject;

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)this.createNonRubyElementFilter());
        this.getViewer().addFilter((ViewerFilter)new LibraryFilter());
    }

    protected NonRubyElementFilter createNonRubyElementFilter() {
        return new NonRubyElementFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IRubyElement || element instanceof IFolder;
            }
        };
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fWrappedViewer = new PackageViewerWrapper();
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        if (memento == null) {
            IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
            this.fCurrViewState = store.getInt(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
        } else {
            Integer integer = memento.getInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
            this.fCurrViewState = integer == null || !this.isValidState(integer) ? 0 : integer;
        }
    }

    private boolean isValidState(int state) {
        return state == 0 || state == 1;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, this.fCurrViewState);
    }

    protected StructuredViewer createViewer(Composite parent) {
        ResourceToItemsMapper.IContentViewerAccessor viewer = this.isInListState() ? this.createTableViewer(parent) : this.createTreeViewer(parent);
        this.fWrappedViewer.setViewer((StructuredViewer)viewer);
        return this.fWrappedViewer;
    }

    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected boolean isInListState() {
        return false;
    }

    private ProblemTableViewer createTableViewer(Composite parent) {
        return new PackagesViewTableViewer(parent, 2);
    }

    private ProblemTreeViewer createTreeViewer(Composite parent) {
        return new PackagesViewTreeViewer(parent, 2);
    }

    protected IContentProvider createContentProvider() {
        return new PackageExplorerContentProvider(false);
    }

    protected String getHelpContextId() {
        return "org.rubypeople.rdt.ui.packages_browsing_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.rubypeople.rdt.ui.browsing.packagestoeditor";
    }

    protected boolean isValidInput(Object element) {
        if (element instanceof IRubyProject || element instanceof ISourceFolderRoot && ((IRubyElement)element).getElementName() != "") {
            try {
                IRubyProject jProject = ((IRubyElement)element).getRubyProject();
                if (jProject != null) {
                    return jProject.getProject().hasNature("org.rubypeople.rdt.core.rubynature");
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    protected boolean isValidElement(Object element) {
        IRubyElement parent;
        if (element instanceof ISourceFolder && (parent = ((ISourceFolder)element).getParent()) != null) {
            return super.isValidElement(parent) || super.isValidElement(parent.getRubyProject());
        }
        return false;
    }

    protected IRubyElement findElementToSelect(IRubyElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 3: {
                return je;
            }
            case 4: {
                return ((IRubyScript)je).getParent();
            }
            case 5: {
                return ((IType)je).getSourceFolder();
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    protected void setInput(Object input) {
        this.setViewerWrapperInput(input);
        super.updateTitle();
    }

    private void setViewerWrapperInput(Object input) {
        this.fWrappedViewer.setViewerInput(input);
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fSwitchActionGroup.fillActionBars(actionBars);
    }

    private void setUpViewer(StructuredViewer viewer) {
        Assert.isTrue((viewer != null ? 1 : 0) != 0);
        RubyUILabelProvider labelProvider = this.createLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(labelProvider));
        viewer.setSorter((ViewerSorter)this.createRubyElementSorter());
        viewer.setUseHashlookup(true);
        this.createContextMenu();
        this.addKeyListener();
        this.hookViewerListeners();
        viewer.setContentProvider(this.createContentProvider());
        this.initDragAndDrop();
    }

    protected RubyElementSorter createRubyElementSorter() {
        return new RubyElementSorter();
    }

    protected void setSiteSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fWrappedViewer);
    }

    protected void createActions() {
        super.createActions();
        this.createSelectAllAction();
        this.fSwitchActionGroup = this.createSwitchActionGroup();
    }

    private MultiActionGroup createSwitchActionGroup() {
        LayoutAction switchToFlatViewAction = new LayoutAction(RubyBrowsingMessages.PackagesView_flatLayoutAction_label, 0);
        LayoutAction switchToHierarchicalViewAction = new LayoutAction(RubyBrowsingMessages.PackagesView_HierarchicalLayoutAction_label, 1);
        RubyPluginImages.setLocalImageDescriptors((IAction)switchToFlatViewAction, "flatLayout.gif");
        RubyPluginImages.setLocalImageDescriptors((IAction)switchToHierarchicalViewAction, "hierarchicalLayout.gif");
        return new LayoutActionGroup(new IAction[]{switchToFlatViewAction, switchToHierarchicalViewAction}, this.fCurrViewState);
    }

    private void switchViewer(int state) {
        if (this.fCurrViewState == state) {
            return;
        }
        this.fCurrViewState = state;
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        store.setValue(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, state);
        StructuredViewer viewer = this.fWrappedViewer.getViewer();
        Object object = viewer.getInput();
        ISelection selection = viewer.getSelection();
        Control control = this.createViewer(this.fWrappedViewer.getControl().getParent()).getControl();
        this.setUpViewer(this.fWrappedViewer);
        this.createSelectAllAction();
        this.fWrappedViewer.setViewerInput(object);
        this.fWrappedViewer.getControl().setFocus();
        this.fWrappedViewer.setSelection(selection, true);
        viewer.getContentProvider().dispose();
        viewer.getControl().dispose();
        if (control != null && !control.isDisposed()) {
            control.setVisible(true);
            control.getParent().layout(true);
        }
    }

    private void createSelectAllAction() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (this.isInListState()) {
            this.fSelectAllAction = new SelectAllAction((TableViewer)this.fWrappedViewer.getViewer());
            actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
        } else {
            actionBars.setGlobalActionHandler("selectAll", null);
            this.fSelectAllAction = null;
        }
        actionBars.updateActionBars();
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je) {
        if (je == null) {
            return null;
        }
        if (je.getElementType() == 2 || je.getElementType() == 1) {
            return this.findInputForRubyElement(je, true);
        }
        return this.findInputForRubyElement(je, false);
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je, boolean canChangeInputType) {
        ISourceFolderRoot packageFragmentRoot;
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            if (canChangeInputType) {
                this.fLastInputWasProject = je.getElementType() == 1;
            }
            return je;
        }
        if (this.fLastInputWasProject && !(packageFragmentRoot = (ISourceFolderRoot)je.getAncestor(2)).isExternal()) {
            return je.getRubyProject();
        }
        return this.findInputForRubyElement(je.getParent(), canChangeInputType);
    }

    protected DecoratingLabelProvider createDecoratingLabelProvider(RubyUILabelProvider provider) {
        return new DecoratingRubyLabelProvider(provider, false);
    }

    private class LayoutAction
    extends Action {
        private int fState;

        public LayoutAction(String text, int state) {
            super(text, 8);
            this.fState = state;
            if (state == 0) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.layout_hierarchical_action");
            }
        }

        public int getState() {
            return this.fState;
        }

        public void setRunnable(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
        }

        public void run() {
            PackagesView.this.switchViewer(this.fState);
        }
    }

    private static class LayoutActionGroup
    extends MultiActionGroup {
        LayoutActionGroup(IAction[] actions, int index) {
            super(actions, index);
        }

        public void fillActionBars(IActionBars actionBars) {
            IMenuManager manager = actionBars.getMenuManager();
            GroupMarker groupMarker = new GroupMarker("layout");
            manager.add((IContributionItem)groupMarker);
            MenuManager newManager = new MenuManager(RubyBrowsingMessages.PackagesView_LayoutActionGroup_layout_label);
            manager.appendToGroup("layout", (IContributionItem)newManager);
            super.addActions((IMenuManager)newManager);
        }
    }
}

