/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;

public class RubyBrowsingContentProvider
extends StandardRubyElementContentProvider
implements IElementChangedListener {
    private RubyBrowsingPart fBrowsingPart;
    private StructuredViewer fViewer;
    private int fReadsInDisplayThread;
    private Object fInput;

    public RubyBrowsingContentProvider(boolean provideMembers, RubyBrowsingPart browsingPart) {
        super(provideMembers);
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        RubyCore.addElementChangedListener((IElementChangedListener)this);
    }

    public boolean hasChildren(Object element) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(element);
            return bl;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        this.startReadInDisplayThread();
        try {
            if (element instanceof Collection) {
                Collection elements = (Collection)element;
                if (elements.isEmpty()) {
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] result = new Object[]{};
                Iterator iter = ((Collection)element).iterator();
                while (iter.hasNext()) {
                    Object[] children = this.getChildren(iter.next());
                    if (children == NO_CHILDREN) continue;
                    result = RubyBrowsingContentProvider.concatenate(result, children);
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof ISourceFolder) {
                Object[] objectArray = this.getFolderContents((ISourceFolder)element);
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof IType) {
                Object[] objectArray = this.removeBlocks(this.getChildren((IType)element));
                return objectArray;
            }
            if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                Object[] objectArray = this.removeBlocks(this.removeImportDeclarations(super.getChildren(element)));
                return objectArray;
            }
            if (element instanceof IRubyProject) {
                Object[] objectArray = this.getSourceFolderRoots((IRubyProject)element);
                return objectArray;
            }
            Object[] objectArray = this.removeBlocks(super.getChildren(element));
            return objectArray;
        }
        catch (RubyModelException rubyModelException) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    private Object[] removeImportDeclarations(Object[] members) {
        ArrayList<Object> tempResult = new ArrayList<Object>(members.length);
        int i = 0;
        while (i < members.length) {
            if (!(members[i] instanceof IImportContainer)) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        return tempResult.toArray();
    }

    protected Object[] getFolderContents(ISourceFolder fragment) throws RubyModelException {
        IRubyScript[] sourceRefs = fragment.getRubyScripts();
        Object[] result = new Object[]{};
        int i = 0;
        while (i < sourceRefs.length) {
            result = RubyBrowsingContentProvider.concatenate(result, this.getChildren(sourceRefs[i]));
            ++i;
        }
        result = this.includeSubtypes(result);
        result = this.convertToLogicalTypes(result);
        return result;
    }

    private Object[] includeSubtypes(Object[] result) throws RubyModelException {
        ArrayList<Object> list = new ArrayList<Object>();
        int j = 0;
        while (j < result.length) {
            if (result[j] instanceof IType) {
                IType type = (IType)result[j];
                list.addAll((Collection)Arrays.asList(this.includeSubtypes(type.getTypes())));
            }
            list.add(result[j]);
            ++j;
        }
        return list.toArray(new Object[list.size()]);
    }

    private Object[] convertToLogicalTypes(Object[] result) {
        HashMap<String, Object> uniques = new HashMap<String, Object>();
        int j = 0;
        while (j < result.length) {
            if (result[j] instanceof IType) {
                IType type = (IType)result[j];
                String name = type.getFullyQualifiedName();
                if (!uniques.containsKey(name)) {
                    uniques.put(name, type);
                } else {
                    IType other = (IType)uniques.get(name);
                    LogicalType logical = new LogicalType(new IType[]{other, type});
                    uniques.put(name, logical);
                }
            }
            ++j;
        }
        Collection values = uniques.values();
        result = values.toArray(new Object[values.size()]);
        return result;
    }

    protected Object[] getSourceFolderRoots(IRubyProject project) throws RubyModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ISourceFolderRoot[] roots = project.getSourceFolderRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            ISourceFolderRoot root = roots[i];
            if (!root.isExternal()) {
                IRubyElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return RubyBrowsingContentProvider.concatenate(list.toArray(), project.getNonRubyResources());
    }

    private Object[] getChildren(IType type) throws RubyModelException {
        IRubyScript parent = type.getRubyScript();
        if (type.getDeclaringType() != null) {
            return type.getChildren();
        }
        IRubyElement[] members = parent.getChildren();
        ArrayList<IRubyElement> tempResult = new ArrayList<IRubyElement>(members.length);
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IImportContainer) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        tempResult.addAll((Collection)Arrays.asList(type.getChildren()));
        return tempResult.toArray();
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
    }

    public void dispose() {
        super.dispose();
        RubyCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IRubyProject) {
            return ((IRubyProject)element).getRubyModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IRubyElement jParent = RubyCore.create((IResource)parent);
            if (jParent != null) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IRubyElement) {
            return ((IRubyElement)element).getParent();
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e.getStatus());
        }
    }

    protected void processDelta(IRubyElementDelta delta) throws RubyModelException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IRubyElement element = delta.getElement();
        boolean isElementValidForView = this.fBrowsingPart.isValidElement(element);
        if (!this.getProvideWorkingCopy() && element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy()) {
            return;
        }
        if (element != null && element.getElementType() == 4 && !this.isOnClassPath((IRubyScript)element)) {
            return;
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(null);
            return;
        }
        if (kind == 2) {
            Object parent = this.internalGetParent(element);
            if (isElementValidForView) {
                if (element instanceof IRubyScript && !((IRubyScript)element).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy()) {
                    if (this.getProvideWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (parent instanceof IRubyScript && this.getProvideWorkingCopy() && !((IRubyScript)parent).isWorkingCopy()) {
                    if (element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy() && parent != null && parent.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(element);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(element, this.fInput)) {
                if (element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(RubyModelUtil.toOriginal((IRubyElement)this.fInput));
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(element)) {
                this.postRefresh(null);
            }
            return;
        }
        if (kind == 1 && delta.getMovedFromElement() != null && element instanceof IRubyScript) {
            return;
        }
        if (kind == 1) {
            if (isElementValidForView) {
                Object parent = this.internalGetParent(element);
                if (element instanceof IRubyScript && !((IRubyScript)element).isWorkingCopy()) {
                    this.postAdd(parent, ((IRubyScript)element).getTypes());
                } else if (!(parent instanceof IRubyScript) || !this.getProvideWorkingCopy() || ((IRubyScript)parent).isWorkingCopy()) {
                    if (element instanceof IRubyScript && ((IRubyScript)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(parent, element);
                    }
                }
            } else if (this.fInput == null) {
                IRubyElement newInput = this.fBrowsingPart.findInputForRubyElement(element);
                if (newInput != null) {
                    this.postAdjustInputAndSetSelection(element);
                }
            } else if (element instanceof IType && this.fBrowsingPart.isValidInput(element)) {
                IRubyElement cu1 = element.getAncestor(4);
                IRubyElement cu2 = ((IRubyElement)this.fInput).getAncestor(4);
                if (cu1 != null && cu2 != null && cu1.equals(cu2)) {
                    this.postAdjustInputAndSetSelection(element);
                }
            }
            return;
        }
        if (kind == 4) {
            if (this.fInput != null && this.fInput.equals(element) && (flags & 8) != 0 && (flags & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (isElementValidForView && (flags & 2) != 0) {
                this.postUpdateIcon(element);
            }
        }
        if (this.isClassPathChange(delta)) {
            this.postRefresh(null);
        }
        IRubyElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(IRubyScript element) throws RubyModelException {
        IRubyProject project = element.getRubyProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnLoadpath((IRubyElement)element);
    }

    private void postUpdateIcon(final IRubyElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    RubyBrowsingContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object root, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    RubyBrowsingContentProvider.this.fViewer.refresh(root, updateLabels);
                }
            }
        });
    }

    private void postRefresh(Object root) {
        this.postRefresh(root, false);
    }

    private void postAdd(Object parent, Object element) {
        this.postAdd(parent, new Object[]{element});
    }

    private void postAdd(final Object parent, final Object[] elements) {
        if (elements == null || elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object[] newElements = RubyBrowsingContentProvider.this.getNewElements(elements);
                    if (RubyBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (RubyBrowsingContentProvider.this.fViewer.testFindItem(parent) == null) {
                            Object root = ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).getInput();
                            if (root != null) {
                                ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).add(root, newElements);
                            }
                        } else {
                            ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).add(parent, newElements);
                        }
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)RubyBrowsingContentProvider.this.fViewer).add(newElements);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)RubyBrowsingContentProvider.this.fViewer).add(newElements);
                    }
                    if (RubyBrowsingContentProvider.this.fViewer.testFindItem(elements[0]) != null) {
                        RubyBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(elements[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] elements) {
        int elementsLength = elements.length;
        ArrayList<Object> result = new ArrayList<Object>(elementsLength);
        int i = 0;
        while (i < elementsLength) {
            Object element = elements[i];
            if (this.fViewer.testFindItem(element) == null) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private void postRemove(Object element) {
        this.postRemove(new Object[]{element});
    }

    private void postRemove(final Object[] elements) {
        if (elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (RubyBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)RubyBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)RubyBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (RubyBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)RubyBrowsingContentProvider.this.fViewer).remove(elements);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = RubyBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setRedraw(false);
                    RubyBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(element);
                    ctrl.setRedraw(true);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fBrowsingPart.setProcessSelectionEvents(false);
            try {
                if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                    ctrl.getDisplay().syncExec(r);
                } else {
                    ctrl.getDisplay().asyncExec(r);
                }
            }
            finally {
                this.fBrowsingPart.setProcessSelectionEvents(true);
            }
        }
    }
}

