/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.Iterator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingContentProvider;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;

public class TypesContentProvider
extends RubyBrowsingContentProvider {
    TypesContentProvider(RubyBrowsingPart browsingPart) {
        super(false, browsingPart);
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            this.startReadInDisplayThread();
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Class<?> clazz = null;
                for (Object item : (IStructuredSelection)element) {
                    if (clazz == null) {
                        clazz = item.getClass();
                    }
                    if (clazz == item.getClass()) {
                        result = TypesContentProvider.concatenate(result, this.getChildren(item));
                        continue;
                    }
                    Object[] objectArray = NO_CHILDREN;
                    return objectArray;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    result = TypesContentProvider.concatenate(result, this.getChildren(iter.next()));
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof ISourceFolderRoot) {
                ISourceFolderRoot root = (ISourceFolderRoot)element;
                IRubyElement[] children = root.getChildren();
                Object[] result = new Object[]{};
                int i = 0;
                while (i < children.length) {
                    result = TypesContentProvider.concatenate(result, this.getChildren(children[i]));
                    ++i;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof IRubyProject) {
                IRubyProject project = (IRubyProject)element;
                ISourceFolderRoot[] roots = project.getSourceFolderRoots();
                Object[] result = new Object[]{};
                int i = 0;
                while (i < roots.length) {
                    result = TypesContentProvider.concatenate(result, this.getChildren(roots[i]));
                    ++i;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            if (element instanceof ISourceFolder) {
                Object[] objectArray = this.getFolderContents((ISourceFolder)element);
                return objectArray;
            }
            if (element instanceof IRubyScript) {
                Object[] objectArray = this.getTopLevelTypes((IRubyScript)element);
                return objectArray;
            }
            if (element instanceof IType) {
                Object[] objectArray = this.getSubTypes((IType)element);
                return objectArray;
            }
            Object[] objectArray = super.getChildren(element);
            return objectArray;
        }
        catch (RubyModelException rubyModelException) {
            Object[] objectArray = NO_CHILDREN;
            return objectArray;
        }
        finally {
            this.finishedReadInDisplayThread();
        }
    }

    private Object[] getTopLevelTypes(IRubyScript script) throws RubyModelException {
        return script.getTypes();
    }

    private Object[] getSubTypes(IType type) throws RubyModelException {
        return type.getTypes();
    }

    public boolean hasChildren(Object element) {
        return element instanceof ISourceFolder || element instanceof IType && super.hasChildren(element);
    }
}

