/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.actions.SelectAllAction;
import org.rubypeople.rdt.internal.ui.browsing.MembersView;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.internal.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.rubypeople.rdt.internal.ui.browsing.TypesContentProvider;
import org.rubypeople.rdt.internal.ui.filters.NonRubyElementFilter;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;

public class TypesView
extends RubyBrowsingPart {
    private SelectAllAction fSelectAllAction;
    private boolean fLastInputWasProject;

    protected RubyUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(2288083697926146L, 1);
    }

    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonRubyElementFilter());
    }

    protected boolean isValidInput(Object element) {
        if (element instanceof IRubyProject || element instanceof ISourceFolderRoot && ((IRubyElement)element).getElementName() != "") {
            try {
                IRubyProject jProject = ((IRubyElement)element).getRubyProject();
                if (jProject != null) {
                    return jProject.getProject().hasNature("org.rubypeople.rdt.core.rubynature");
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    protected IContentProvider createContentProvider() {
        return new TypesContentProvider(this);
    }

    protected boolean isValidElement(Object element) {
        if (element instanceof IRubyScript) {
            return super.isValidElement(((IRubyScript)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return this.isValidElement(type.getRubyScript());
        }
        return false;
    }

    protected IRubyElement findElementToSelect(IRubyElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 5: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return this.getSuitableRubyElement(type);
            }
            case 4: {
                return this.getTypeForRubyScript((IRubyScript)je);
            }
            case 8: 
            case 16: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect((IRubyElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je) {
        if (je == null) {
            return null;
        }
        if (je.getElementType() == 2 || je.getElementType() == 1) {
            return this.findInputForRubyElement(je, true);
        }
        return this.findInputForRubyElement(je, false);
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je, boolean canChangeInputType) {
        ISourceFolderRoot packageFragmentRoot;
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            if (canChangeInputType) {
                this.fLastInputWasProject = je.getElementType() == 1;
            }
            return je;
        }
        if (this.fLastInputWasProject && !(packageFragmentRoot = (ISourceFolderRoot)je.getAncestor(2)).isExternal()) {
            return je.getRubyProject();
        }
        return this.findInputForRubyElement(je.getParent(), canChangeInputType);
    }

    protected String getHelpContextId() {
        return "org.rubypeople.rdt.ui.types_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.rubypeople.rdt.ui.browsing.typestoeditor";
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
    }

    protected DecoratingLabelProvider createDecoratingLabelProvider(RubyUILabelProvider provider) {
        DecoratingLabelProvider decoratingLabelProvider = super.createDecoratingLabelProvider(provider);
        provider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return decoratingLabelProvider;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof MembersView) {
            return;
        }
        super.selectionChanged(part, selection);
    }
}

