/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallHierarchy;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallLocation;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodWrapper;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.RubyUI;

public class CallHierarchyUI {
    private static final int DEFAULT_MAX_CALL_DEPTH = 10;
    private static final String PREF_MAX_CALL_DEPTH = "PREF_MAX_CALL_DEPTH";
    private static CallHierarchyUI fgInstance;

    private CallHierarchyUI() {
    }

    public static CallHierarchyUI getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyUI();
        }
        return fgInstance;
    }

    public int getMaxCallDepth() {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        int maxCallDepth = settings.getInt(PREF_MAX_CALL_DEPTH);
        if (maxCallDepth < 1 || maxCallDepth > 99) {
            maxCallDepth = 10;
        }
        return maxCallDepth;
    }

    public void setMaxCallDepth(int maxCallDepth) {
        IPreferenceStore settings = RubyPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_MAX_CALL_DEPTH, maxCallDepth);
    }

    public static void jumpToMember(IRubyElement element) {
        if (element != null) {
            try {
                IEditorPart methodEditor = EditorUtility.openInEditor(element, true);
                RubyUI.revealInEditor(methodEditor, element);
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            catch (PartInitException e) {
                RubyPlugin.log(e);
            }
        }
    }

    public static void jumpToLocation(CallLocation callLocation) {
        try {
            IEditorPart methodEditor = EditorUtility.openInEditor(callLocation.getMember(), false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        catch (PartInitException e) {
            RubyPlugin.log(e);
        }
    }

    public static boolean openInEditor(Object element, Shell shell, String title) {
        int selectionLength;
        int selectionStart;
        IMember enclosingMember;
        CallLocation callLocation;
        block8: {
            block9: {
                ISourceRange selectionRange;
                block10: {
                    callLocation = CallHierarchy.getCallLocation(element);
                    if (callLocation != null) {
                        enclosingMember = callLocation.getMember();
                        selectionStart = callLocation.getStart();
                        selectionLength = callLocation.getEnd() - selectionStart;
                        break block8;
                    }
                    if (!(element instanceof MethodWrapper)) break block9;
                    enclosingMember = ((MethodWrapper)((Object)element)).getMember();
                    selectionRange = enclosingMember.getNameRange();
                    if (selectionRange == null) {
                        selectionRange = enclosingMember.getSourceRange();
                    }
                    if (selectionRange != null) break block10;
                    return true;
                }
                selectionStart = selectionRange.getOffset();
                selectionLength = selectionRange.getLength();
                break block8;
            }
            return true;
        }
        try {
            boolean activateOnOpen = OpenStrategy.activateOnOpen();
            IEditorPart methodEditor = EditorUtility.openInEditor(enclosingMember, activateOnOpen);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(selectionStart, selectionLength);
            }
            return true;
        }
        catch (RubyModelException e) {
            RubyPlugin.log((IStatus)new Status(4, RubyPlugin.getPluginId(), 10001, CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (Throwable)e));
            ErrorDialog.openError((Shell)shell, (String)title, (String)CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (IStatus)e.getStatus());
            return false;
        }
        catch (PartInitException x) {
            String name = callLocation != null ? callLocation.getCalledMember().getElementName() : (element instanceof MethodWrapper ? ((MethodWrapper)((Object)element)).getName() : "");
            MessageDialog.openError((Shell)shell, (String)title, (String)Messages.format(CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_messageArgs, new String[]{name, x.getMessage()}));
            return false;
        }
    }

    public static IEditorPart isOpenInEditor(Object elem) {
        IMember javaElement = null;
        if (elem instanceof MethodWrapper) {
            javaElement = ((MethodWrapper)((Object)elem)).getMember();
        } else if (elem instanceof CallLocation) {
            javaElement = ((CallLocation)elem).getCalledMember();
        }
        if (javaElement != null) {
            return EditorUtility.isOpenInEditor(javaElement);
        }
        return null;
    }

    public static IRubyElement[] getCandidates(Object input) {
        if (!(input instanceof IRubyElement)) {
            return null;
        }
        IRubyElement elem = (IRubyElement)input;
        if (elem.getElementType() == 6) {
            return new IRubyElement[]{elem};
        }
        return null;
    }

    public static CallHierarchyViewPart open(IRubyElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IRubyElement input = null;
        if (candidates.length > 1) {
            String title = CallHierarchyMessages.CallHierarchyUI_selectionDialog_title;
            String message = CallHierarchyMessages.CallHierarchyUI_selectionDialog_message;
            input = OpenActionUtil.selectRubyElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return CallHierarchyUI.openInViewPart(window, input);
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, RubyModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof IRubyElement) {
            EditorUtility.revealInEditor(part, (IRubyElement)input);
        }
    }

    private static CallHierarchyViewPart openInViewPart(IWorkbenchWindow window, IRubyElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            CallHierarchyViewPart result = (CallHierarchyViewPart)page.showView("org.rubypeople.rdt.callhierarchy.view");
            result.setMethod((IMethod)input);
            CallHierarchyUI.openEditor(input, false);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CallHierarchyMessages.CallHierarchyUI_error_open_view, e.getMessage());
            return null;
        }
    }

    static ISelection convertSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> javaElements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                IMember member;
                if (element instanceof MethodWrapper) {
                    member = ((MethodWrapper)((Object)element)).getMember();
                    if (member == null) continue;
                    javaElements.add(member);
                    continue;
                }
                if (element instanceof IMember) {
                    javaElements.add(element);
                    continue;
                }
                if (!(element instanceof CallLocation)) continue;
                member = ((CallLocation)element).getMember();
                javaElements.add(member);
            }
            return new StructuredSelection(javaElements);
        }
        return StructuredSelection.EMPTY;
    }
}

