/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallLocation;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodWrapper;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

class OpenLocationAction
extends SelectionDispatchAction {
    private CallHierarchyViewPart fPart;

    public OpenLocationAction(CallHierarchyViewPart part, IWorkbenchSite site) {
        super(site);
        this.fPart = part;
        this.setText(CallHierarchyMessages.OpenLocationAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenLocationAction_tooltip);
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof MethodWrapper || element instanceof CallLocation) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.fPart.getSelection();
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            boolean noError = CallHierarchyUI.openInEditor(iter.next(), this.getShell(), this.getDialogTitle());
            if (noError) continue;
            return;
        }
    }

    private String getDialogTitle() {
        return CallHierarchyMessages.OpenLocationAction_error_title;
    }
}

