/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeAction;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;

class SearchScopeHierarchyAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeHierarchyAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_hierarchy_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_hierarchy_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IRubySearchScope getSearchScope() {
        try {
            IMethod method = this.fGroup.getView().getMethod();
            if (method != null) {
                return SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
            }
            return null;
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
            return null;
        }
    }

    public int getSearchScopeType() {
        return 3;
    }

    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        return RubySearchScopeFactory.getInstance().getHierarchyScopeDescription(method.getDeclaringType());
    }
}

