/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeAction;
import org.rubypeople.rdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;

class SearchScopeProjectAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeProjectAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_project_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_project_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IRubySearchScope getSearchScope() {
        IMethod method = this.fGroup.getView().getMethod();
        if (method == null) {
            return null;
        }
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        return factory.createRubyProjectSearchScope(method.getRubyProject(), true);
    }

    public int getSearchScopeType() {
        return 2;
    }

    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        if (method != null) {
            RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
            return factory.getProjectScopeDescription(method.getRubyProject(), true);
        }
        return "";
    }
}

