/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.rubypeople.rdt.internal.ui.dialogs.ISelectionValidator;
import org.rubypeople.rdt.internal.ui.dialogs.SelectionStatusDialog;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.viewsupport.ContainerCheckedTreeViewer;

public class CheckedTreeSelectionDialog
extends SelectionStatusDialog {
    private CheckboxTreeViewer fViewer;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private ISelectionValidator fValidator = null;
    private ViewerSorter fSorter;
    private String fEmptyListMessage = "No entries available";
    private IStatus fCurrStatus = new StatusInfo();
    private List fFilters;
    private Object fInput;
    private boolean fIsEmpty;
    private int fWidth = 60;
    private int fHeight = 18;
    private boolean fContainerMode;
    private Object[] fExpandedElements;

    public CheckedTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fContentProvider = contentProvider;
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        this.fContainerMode = false;
        this.fExpandedElements = null;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    public void setContainerMode(boolean containerMode) {
        this.fContainerMode = containerMode;
    }

    public void setInitialSelection(Object selection) {
        this.setInitialSelections(new Object[]{selection});
    }

    public void setEmptyListMessage(String message) {
        this.fEmptyListMessage = message;
    }

    public void setSorter(ViewerSorter sorter) {
        this.fSorter = sorter;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList(4);
        }
        this.fFilters.add(filter);
    }

    public void setValidator(ISelectionValidator validator) {
        this.fValidator = validator;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setExpandedElements(Object[] elements) {
        this.fExpandedElements = elements;
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    protected void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.fViewer.getCheckedElements());
                this.updateStatus(this.fCurrStatus);
            } else if (!this.fCurrStatus.isOK()) {
                this.fCurrStatus = new StatusInfo();
            }
        } else {
            this.fCurrStatus = new StatusInfo(4, this.fEmptyListMessage);
        }
        this.updateStatus(this.fCurrStatus);
    }

    public int open() {
        this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                CheckedTreeSelectionDialog.this.access$superOpen();
            }
        });
        return this.getReturnCode();
    }

    private void access$superOpen() {
        super.open();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fViewer.getCheckedElements()));
    }

    public void create() {
        super.create();
        List initialSelections = this.getInitialElementSelections();
        if (initialSelections != null) {
            this.fViewer.setCheckedElements(initialSelections.toArray());
        }
        if (this.fExpandedElements != null) {
            this.fViewer.setExpandedElements(this.fExpandedElements);
        }
        this.updateOKStatus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label messageLabel = this.createMessageArea(composite);
        Tree treeWidget = this.createTreeViewer(composite);
        Composite buttonComposite = this.createSelectionButtons(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        treeWidget.setLayoutData((Object)data);
        if (this.fIsEmpty) {
            messageLabel.setEnabled(false);
            treeWidget.setEnabled(false);
            buttonComposite.setEnabled(false);
        }
        return composite;
    }

    private Tree createTreeViewer(Composite parent) {
        this.fViewer = this.fContainerMode ? new ContainerCheckedTreeViewer(parent, 2048) : new CheckboxTreeViewer(parent, 2048);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setSorter(this.fSorter);
        if (this.fFilters != null) {
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter((ViewerFilter)this.fFilters.get(i));
                ++i;
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer.getTree();
    }

    private Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, "Select &All", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(CheckedTreeSelectionDialog.this.fContentProvider.getElements(CheckedTreeSelectionDialog.this.fInput));
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, "&Deselect All", false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckedTreeSelectionDialog.this.fViewer.setCheckedElements(new Object[0]);
                CheckedTreeSelectionDialog.this.updateOKStatus();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }

    private boolean evaluateIfTreeEmpty(Object input) {
        Object[] elements = this.fContentProvider.getElements(input);
        if (elements.length > 0 && this.fFilters != null) {
            int i = 0;
            while (i < this.fFilters.size()) {
                ViewerFilter curr = (ViewerFilter)this.fFilters.get(i);
                elements = curr.filter((Viewer)this.fViewer, input, elements);
                ++i;
            }
        }
        return elements.length == 0;
    }
}

