/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.TypeNameRequestor;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.corext.util.OpenTypeHistory;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.dialogs.TypeSelectionComponent;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.dialogs.TypeSelectionExtension;

public class TypeSelectionDialog2
extends SelectionStatusDialog {
    private String fTitle;
    private boolean fMultipleSelection;
    private IRunnableContext fRunnableContext;
    private IRubySearchScope fScope;
    private int fElementKind;
    private String fInitialFilter;
    private int fSelectionMode;
    private ISelectionStatusValidator fValidator;
    private TypeSelectionComponent fContent;
    private TypeSelectionExtension fExtension;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static boolean fgFirstTime = true;

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IRubySearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public TypeSelectionDialog2(Shell parent, boolean multi, IRunnableContext context, IRubySearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMultipleSelection = multi;
        this.fRunnableContext = context;
        this.fScope = scope;
        this.fElementKind = elementKinds;
        this.fSelectionMode = 0;
        this.fExtension = extension;
        if (this.fExtension != null) {
            this.fValidator = this.fExtension.getSelectionValidator();
        }
    }

    public void setFilter(String filter) {
        this.setFilter(filter, 2);
    }

    public void setFilter(String filter, int selectionMode) {
        this.fInitialFilter = filter;
        this.fSelectionMode = selectionMode;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected TypeInfo[] getSelectedTypes() {
        if (this.fContent == null || this.fContent.isDisposed()) {
            return null;
        }
        return this.fContent.getSelection();
    }

    public void create() {
        super.create();
        this.fContent.populate(this.fSelectionMode);
        this.getOkButton().setEnabled(this.fContent.getSelection().length > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.fContent = new TypeSelectionComponent(area, 0, this.getMessage(), this.fMultipleSelection, this.fScope, this.fElementKind, this.fInitialFilter, new TitleLabel(), this.fExtension);
        GridData gd = new GridData(1808);
        this.fContent.setLayoutData(gd);
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleDefaultSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                TypeSelectionDialog2.this.handleWidgetSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }
        });
        return area;
    }

    protected void handleDefaultSelected(TypeInfo[] selection) {
        if (selection.length == 0) {
            return;
        }
        this.okPressed();
    }

    protected void handleWidgetSelected(TypeInfo[] selection) {
        Status status = null;
        if (selection.length == 0) {
            status = new Status(4, RubyPlugin.getPluginId(), 4, "", null);
        } else {
            try {
                if (this.fValidator != null) {
                    ArrayList<IType> jElements = new ArrayList<IType>();
                    int i = 0;
                    while (i < selection.length) {
                        IType type = selection[i].resolveType(this.fScope);
                        if (type == null) {
                            status = new Status(4, RubyPlugin.getPluginId(), 4, Messages.format(RubyUIMessages.TypeSelectionDialog_error_type_doesnot_exist, selection[i].getFullyQualifiedName()), null);
                            break;
                        }
                        jElements.add(type);
                        ++i;
                    }
                    if (status == null) {
                        status = this.fValidator.validate(jElements.toArray());
                    }
                } else {
                    status = new Status(0, RubyPlugin.getPluginId(), 0, "", null);
                }
            }
            catch (RubyModelException e) {
                status = new Status(4, RubyPlugin.getPluginId(), 4, e.getStatus().getMessage(), null);
            }
        }
        this.updateStatus((IStatus)status);
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RubyUIMessages.TypeSelectionDialog_error3Title, RubyUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (this.fInitialFilter == null && (window = RubyPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && RubyConventions.validateRubyTypeName((String)text).isOK()) {
            this.fInitialFilter = text;
            this.fSelectionMode = 2;
        }
        return super.open();
    }

    public boolean close() {
        boolean result;
        try {
            if (this.getReturnCode() == 0) {
                OpenTypeHistory.getInstance().save();
            }
        }
        finally {
            result = super.close();
        }
        return result;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    protected void computeResult() {
        TypeInfo[] selected = this.fContent.getSelection();
        if (selected == null || selected.length == 0) {
            this.setResult(null);
            return;
        }
        if (this.fScope == null) {
            this.fScope = this.fContent.getScope();
        }
        OpenTypeHistory history = OpenTypeHistory.getInstance();
        ArrayList<IType> result = new ArrayList<IType>(selected.length);
        int i = 0;
        while (i < selected.length) {
            try {
                TypeInfo typeInfo = selected[i];
                IType type = typeInfo.resolveType(this.fScope);
                if (type == null) {
                    String title = RubyUIMessages.TypeSelectionDialog_errorTitle;
                    String message = Messages.format(RubyUIMessages.TypeSelectionDialog_dialogMessage, typeInfo.getPath());
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                    history.remove(typeInfo);
                    this.setResult(null);
                } else {
                    history.accessed(typeInfo);
                    result.add(type);
                }
            }
            catch (RubyModelException e) {
                String title = RubyUIMessages.MultiTypeSelectionDialog_errorTitle;
                String message = RubyUIMessages.MultiTypeSelectionDialog_errorMessage;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
            }
            ++i;
        }
        this.setResult(result);
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        class ConsistencyRunnable
        implements IRunnableWithProgress {
            ConsistencyRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (fgFirstTime) {
                    IJobManager manager = Platform.getJobManager();
                    manager.join((Object)"org.rubypeople.rdt.ui", monitor);
                }
                OpenTypeHistory history = OpenTypeHistory.getInstance();
                if (fgFirstTime || history.isEmpty()) {
                    monitor.beginTask(RubyUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    if (history.needConsistencyCheck()) {
                        this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                        history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    } else {
                        this.refreshSearchIndices(monitor);
                    }
                    monitor.done();
                    fgFirstTime = false;
                } else {
                    history.checkConsistency(monitor);
                }
            }

            public boolean needsExecution() {
                OpenTypeHistory history = OpenTypeHistory.getInstance();
                return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
            }

            private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    new SearchEngine().searchAllTypeNames(null, "_______________".toCharArray(), 8, 5, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(){}, 3, monitor);
                }
                catch (RubyModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        ConsistencyRunnable runnable = new ConsistencyRunnable();
        if (!runnable.needsExecution()) {
            return;
        }
        IRunnableContext context = this.fRunnableContext != null ? this.fRunnableContext : PlatformUI.getWorkbench().getProgressService();
        context.run(true, true, (IRunnableWithProgress)runnable);
    }

    private class TitleLabel
    implements TypeSelectionComponent.ITitleLabel {
        private TitleLabel() {
        }

        public void setText(String text) {
            if (text == null || text.length() == 0) {
                TypeSelectionDialog2.this.getShell().setText(TypeSelectionDialog2.this.fTitle);
            } else {
                TypeSelectionDialog2.this.getShell().setText(Messages.format(RubyUIMessages.TypeSelectionDialog2_title_format, new String[]{TypeSelectionDialog2.this.fTitle, text}));
            }
        }
    }
}

