/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerPart;
import org.rubypeople.rdt.internal.ui.packageview.PackagesMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.RubyUI;

class GotoTypeAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoTypeAction(PackageExplorerPart part) {
        this.setText(PackagesMessages.GotoType_action_label);
        this.setDescription(PackagesMessages.GotoType_action_description);
        this.fPackageExplorer = part;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.goto_type_action");
    }

    public void run() {
        Shell shell = RubyPlugin.getActiveWorkbenchShell();
        SelectionDialog dialog = null;
        try {
            dialog = RubyUI.createTypeDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(), 0, false);
        }
        catch (RubyModelException e) {
            String title = this.getDialogTitle();
            String message = PackagesMessages.GotoType_error_message;
            ExceptionHandler.handle((CoreException)((Object)e), title, message);
            return;
        }
        dialog.setTitle(this.getDialogTitle());
        dialog.setMessage(PackagesMessages.GotoType_dialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.gotoType((IType)types[0]);
        }
    }

    private void gotoType(IType type) {
        PackageExplorerPart view;
        IRubyScript cu = (IRubyScript)type.getAncestor(4);
        IRubyScript element = null;
        if (cu != null) {
            element = cu.getPrimary();
        }
        if (element != null && (view = PackageExplorerPart.openInActivePerspective()) != null) {
            view.selectReveal((ISelection)new StructuredSelection((Object)element));
            if (!element.equals(this.getSelectedElement(view))) {
                MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)Messages.format(PackagesMessages.PackageExplorer_element_not_present, element.getElementName()));
            }
        }
    }

    private Object getSelectedElement(PackageExplorerPart view) {
        return ((IStructuredSelection)view.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.GotoType_dialog_title;
    }
}

