/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.util.Assert;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerProblemsDecorator;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;

public class PackageExplorerLabelProvider
extends AppearanceAwareLabelProvider {
    private PackageExplorerContentProvider fContentProvider;
    private boolean fIsFlatLayout;
    private PackageExplorerProblemsDecorator fProblemDecorator = new PackageExplorerProblemsDecorator();

    public PackageExplorerLabelProvider(long textFlags, int imageFlags, PackageExplorerContentProvider cp) {
        super(textFlags, imageFlags);
        this.addLabelDecorator(this.fProblemDecorator);
        Assert.isNotNull((Object)cp);
        this.fContentProvider = cp;
    }

    public String getText(Object element) {
        if (this.fIsFlatLayout || !(element instanceof ISourceFolder)) {
            return super.getText(element);
        }
        ISourceFolder fragment = (ISourceFolder)element;
        if (fragment.isDefaultPackage()) {
            return super.getText(fragment);
        }
        Object parent = this.fContentProvider.getSourceFolderProvider().getParent(fragment);
        if (parent instanceof ISourceFolder) {
            return this.getNameDelta((ISourceFolder)parent, fragment);
        }
        if (parent instanceof IFolder) {
            int prefixLength = this.getPrefixLength((IFolder)parent);
            return fragment.getElementName().substring(prefixLength);
        }
        return super.getText(fragment);
    }

    private int getPrefixLength(IFolder folder) {
        Object parent = this.fContentProvider.getParent(folder);
        int folderNameLenght = folder.getName().length() + 1;
        if (parent instanceof ISourceFolder) {
            String fragmentName = ((ISourceFolder)parent).getElementName();
            return fragmentName.length() + 1 + folderNameLenght;
        }
        if (parent instanceof IFolder) {
            return this.getPrefixLength((IFolder)parent) + folderNameLenght;
        }
        return folderNameLenght;
    }

    private String getNameDelta(ISourceFolder topFragment, ISourceFolder bottomFragment) {
        String bottomName;
        String topName = topFragment.getElementName();
        if (topName.equals(bottomName = bottomFragment.getElementName())) {
            return topName;
        }
        String deltaname = bottomName.substring(topName.length() + 1);
        return deltaname;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
        this.fProblemDecorator.setIsFlatLayout(state);
    }
}

