/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFolderProvider
implements IPropertyChangeListener {
    private TreeViewer fViewer;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();

    public SourceFolderProvider() {
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        block11: {
            try {
                if (parentElement instanceof IFolder) {
                    IResource[] resources = ((IFolder)parentElement).members();
                    return this.filter(this.getFolders(resources)).toArray();
                }
                if (!(parentElement instanceof IRubyElement)) break block11;
                IRubyElement iRubyElement = (IRubyElement)parentElement;
                int type = iRubyElement.getElementType();
                switch (type) {
                    case 1: {
                        IRubyProject project = (IRubyProject)iRubyElement;
                        ISourceFolderRoot root = project.findSourceFolderRoot(project.getPath());
                        if (root != null) {
                            List<IRubyElement> children = SourceFolderProvider.getTopLevelChildren(root);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    case 2: {
                        ISourceFolderRoot root = (ISourceFolderRoot)parentElement;
                        if (root.exists()) {
                            return this.filter(SourceFolderProvider.getTopLevelChildren(root)).toArray();
                        }
                        break;
                    }
                    case 3: {
                        ISourceFolder packageFragment = (ISourceFolder)parentElement;
                        if (!packageFragment.isDefaultPackage()) {
                            ISourceFolderRoot root = (ISourceFolderRoot)packageFragment.getParent();
                            List children = SourceFolderProvider.getPackageChildren(root, packageFragment);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CoreException e) {
                RubyPlugin.log(e);
            }
        }
        return new Object[0];
    }

    private List filter(List children) throws RubyModelException {
        if (this.fFoldPackages) {
            int size = children.size();
            int i = 0;
            while (i < size) {
                ISourceFolder collapsed;
                ISourceFolder fragment;
                Object curr = children.get(i);
                if (curr instanceof ISourceFolder && !(fragment = (ISourceFolder)curr).isDefaultPackage() && this.isEmpty(fragment) && (collapsed = this.getCollapsed(fragment)) != null) {
                    children.set(i, collapsed);
                }
                ++i;
            }
        }
        return children;
    }

    private ISourceFolder getCollapsed(ISourceFolder pack) throws RubyModelException {
        IRubyElement[] children = ((ISourceFolderRoot)pack.getParent()).getChildren();
        ISourceFolder child = SourceFolderProvider.getSinglePackageChild(pack, children);
        while (child != null && this.isEmpty(child)) {
            ISourceFolder collapsed = SourceFolderProvider.getSinglePackageChild(child, children);
            if (collapsed == null) {
                return child;
            }
            child = collapsed;
        }
        return child;
    }

    private boolean isEmpty(ISourceFolder fragment) throws RubyModelException {
        return !fragment.containsRubyResources() && fragment.getNonRubyResources().length == 0;
    }

    private static ISourceFolder getSinglePackageChild(ISourceFolder fragment, IRubyElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        ISourceFolder found = null;
        int i = 0;
        while (i < children.length) {
            IRubyElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (found == null) {
                    found = (ISourceFolder)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private static List getPackageChildren(ISourceFolderRoot parent, ISourceFolder fragment) throws RubyModelException {
        IRubyElement[] children = parent.getChildren();
        ArrayList<IRubyElement> list = new ArrayList<IRubyElement>(children.length);
        String prefix = String.valueOf(fragment.getElementName()) + File.separatorChar;
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            String name;
            IRubyElement element = children[i];
            if (element instanceof ISourceFolder && (name = element.getElementName()).startsWith(prefix) && name.length() > prefixLen && name.indexOf(File.separatorChar, prefixLen) == -1) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    private static List<IRubyElement> getTopLevelChildren(ISourceFolderRoot root) throws RubyModelException {
        IRubyElement[] elements = root.getChildren();
        ArrayList<IRubyElement> topLevelElements = new ArrayList<IRubyElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IRubyElement iRubyElement = elements[i];
            if (iRubyElement instanceof ISourceFolder && iRubyElement.getElementName().indexOf(File.separatorChar) == -1 && !((ISourceFolder)iRubyElement).isDefaultPackage()) {
                topLevelElements.add(iRubyElement);
            }
            ++i;
        }
        return topLevelElements;
    }

    private List getFolders(IResource[] resources) throws RubyModelException {
        ArrayList<IRubyElement> list = new ArrayList<IRubyElement>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IRubyElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = RubyCore.create((IResource)(folder = (IFolder)resource))) instanceof ISourceFolder) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    public Object getParent(Object element) {
        if (element instanceof ISourceFolder) {
            ISourceFolder frag = (ISourceFolder)element;
            return this.filterParent(this.getActualParent(frag));
        }
        return null;
    }

    private Object getActualParent(ISourceFolder fragment) {
        try {
            IRubyElement parent;
            if (fragment.exists() && (parent = fragment.getParent()) instanceof ISourceFolderRoot && parent.exists()) {
                ISourceFolderRoot root = (ISourceFolderRoot)parent;
                if (root.isExternal()) {
                    return this.findNextLevelParentByElementName(fragment);
                }
                IResource resource = fragment.getUnderlyingResource();
                if (resource != null && resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IContainer res = folder.getParent();
                    IRubyElement el = RubyCore.create((IResource)res);
                    if (el != null) {
                        return el;
                    }
                    return res;
                }
                return parent;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return null;
    }

    private Object filterParent(Object parent) {
        if (this.fFoldPackages && parent != null) {
            try {
                ISourceFolder fragment;
                if (parent instanceof ISourceFolder && this.isEmpty(fragment = (ISourceFolder)parent) && this.hasSingleChild(fragment)) {
                    return this.filterParent(this.getActualParent(fragment));
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
        return parent;
    }

    private boolean hasSingleChild(ISourceFolder fragment) {
        return this.getChildren(fragment).length == 1;
    }

    private Object findNextLevelParentByElementName(ISourceFolder child) {
        String name = child.getElementName();
        int index = name.lastIndexOf(File.separatorChar);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            ISourceFolder element = ((ISourceFolderRoot)child.getParent()).getSourceFolder(realParentName);
            if (element.exists()) {
                return element;
            }
        }
        return child.getParent();
    }

    public boolean hasChildren(Object element) {
        ISourceFolder fragment;
        if (element instanceof ISourceFolder && (fragment = (ISourceFolder)element).isDefaultPackage()) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    public void processDelta(IRubyElementDelta delta) {
        int kind = delta.getKind();
        final IRubyElement element = delta.getElement();
        if (element instanceof ISourceFolder) {
            if (kind == 2) {
                this.postRunnable(new Runnable(){

                    public void run() {
                        Control ctrl = SourceFolderProvider.this.fViewer.getControl();
                        if (ctrl != null && !ctrl.isDisposed()) {
                            if (!SourceFolderProvider.this.fFoldPackages) {
                                SourceFolderProvider.this.fViewer.remove((Object)element);
                            } else {
                                SourceFolderProvider.this.refreshGrandParent(element);
                            }
                        }
                    }
                });
                return;
            }
            if (kind == 1) {
                final Object parent = this.getParent(element);
                if (parent != null) {
                    this.postRunnable(new Runnable(){

                        public void run() {
                            Control ctrl = SourceFolderProvider.this.fViewer.getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                if (!SourceFolderProvider.this.fFoldPackages) {
                                    SourceFolderProvider.this.fViewer.add(parent, (Object)element);
                                } else {
                                    SourceFolderProvider.this.refreshGrandParent(element);
                                }
                            }
                        }
                    });
                }
                return;
            }
        }
    }

    private void refreshGrandParent(IRubyElement element) {
        if (element instanceof ISourceFolder) {
            IFolder folder;
            Object gp = this.getGrandParent((ISourceFolder)element);
            if (gp instanceof IRubyElement) {
                IRubyElement el = (IRubyElement)gp;
                if (el.exists()) {
                    this.fViewer.refresh(gp);
                }
            } else if (gp instanceof IFolder && (folder = (IFolder)gp).exists()) {
                this.fViewer.refresh((Object)folder);
            }
        }
    }

    private Object getGrandParent(ISourceFolder element) {
        Object parent = this.findNextLevelParentByElementName(element);
        if (parent instanceof ISourceFolderRoot) {
            ISourceFolderRoot root = (ISourceFolderRoot)parent;
            if (this.isRootProject(root)) {
                return root.getRubyProject();
            }
            return root;
        }
        Object grandParent = this.getParent(parent);
        if (grandParent == null) {
            return parent;
        }
        return grandParent;
    }

    private boolean isRootProject(ISourceFolderRoot root) {
        return "".equals(root.getElementName());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return false;
    }
}

