/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;

public class DebuggerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public DebuggerPreferencePage() {
        super(1);
        Preferences launchingPreferences = LaunchingPlugin.getDefault().getPluginPreferences();
        this.setPreferenceStore(new PreferencesAdapter(launchingPreferences));
        this.setDescription(PreferencesMessages.DebuggerPreferencePage_description_label);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("useRubyDebug", PreferencesMessages.DebuggerPreferencePage_useRubyDebug_label, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("verboseDebugger", PreferencesMessages.DebuggerPreferencePage_verboseDebugger_label, this.getFieldEditorParent()));
    }

    protected Control createContents(Composite parent) {
        String installLocation;
        Control result = super.createContents(parent);
        Label label = new Label(parent, 64);
        URL entry = LaunchingPlugin.getDefault().getBundle().getEntry("/");
        try {
            installLocation = FileLocator.resolve((URL)entry).toString();
        }
        catch (IOException iOException) {
            installLocation = "<eclipseInstallation>/plugins/org.rubypeople.rdt.launching_<version>";
        }
        String message = MessageFormat.format(PreferencesMessages.DebuggerPreferencePage_useRubyDebug_comment, installLocation);
        label.setText(message);
        FontData[] fontData = this.getFont().getFontData();
        if (fontData.length > 0) {
            FontData italicFont = new FontData(fontData[0].getName(), fontData[0].getHeight(), 2);
            label.setFont(new Font(null, italicFont));
        }
        return result;
    }

    public void init(IWorkbench workbench) {
    }
}

