/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.OverlayPreferenceStore;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.preferences.RubySourcePreviewerUpdater;
import org.rubypeople.rdt.internal.ui.preferences.SyntaxColoringStore;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.internal.ui.text.SimpleRubySourceViewerConfiguration;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.util.SWTUtil;
import org.rubypeople.rdt.ui.text.IColorManager;

class RubyEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String DIALOGSTORE_LASTLOADPATH = "org.rubypeople.rdt.ui.syntaxcoloring.loadpath";
    private static final String DIALOGSTORE_LASTSAVEPATH = "org.rubypeople.rdt.ui.syntaxcoloring.savepath";
    private static final String BOLD = "_bold";
    private static final String BACKGROUND = "_background";
    private static final String BACKGROUND_ENABLED = "_background_enabled";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private static final String COMPILER_TASK_TAGS = "org.rubypeople.rdt.core.compiler.taskTags";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.RubyEditorPreferencePage_multiLineComment, "color_ruby_multiline_comment"}, {PreferencesMessages.RubyEditorPreferencePage_singleLineComment, "color_ruby_singleline_comment"}, {PreferencesMessages.RubyEditorPreferencePage_rubyCommentTaskTags, "color_ruby_task"}, {PreferencesMessages.RubyEditorPreferencePage_keywords, "color_ruby_keyword"}, {PreferencesMessages.RubyEditorPreferencePage_strings, "color_ruby_string"}, {PreferencesMessages.RubyEditorPreferencePage_characters, "color_ruby_character"}, {PreferencesMessages.RubyEditorPreferencePage_commands, "color_ruby_command"}, {PreferencesMessages.RubyEditorPreferencePage_fixnums, "color_ruby_fixnum"}, {PreferencesMessages.RubyEditorPreferencePage_globals, "color_ruby_global"}, {PreferencesMessages.RubyEditorPreferencePage_regular_expressions, "color_ruby_regexp"}, {PreferencesMessages.RubyEditorPreferencePage_symbols, "color_ruby_symbol"}, {PreferencesMessages.RubyEditorPreferencePage_variables, "color_ruby_instance_variable"}, {PreferencesMessages.RubyEditorPreferencePage_others, "color_ruby_default"}};
    private final String fRubyCategory = PreferencesMessages.RubyEditorPreferencePage_coloring_category_ruby;
    private ColorSelector fSyntaxForegroundColorEditor;
    private ColorSelector fSyntaxBackgroundColorEditor;
    private Label fColorEditorLabel;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List fListModel = new ArrayList();
    private StructuredViewer fListViewer;
    private RubySourceViewer fPreviewViewer;
    private IColorManager fColorManager = new RubyColorManager(false);
    private FontMetrics fFontMetrics;
    private Button fLoadButton;
    private Button fSaveButton;
    private Composite fComposite;
    private Button fEnableBackgroundCheckbox;

    public RubyEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BACKGROUND, String.valueOf(this.fSyntaxColorListModel[i][1]) + BACKGROUND_ENABLED, String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[i][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[i][1]) + UNDERLINE));
            ++i;
        }
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        int n = this.fListModel.size();
        while (i < n) {
            HighlightingColorListItem item = (HighlightingColorListItem)this.fListModel.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getBackgroundKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBackgroundEnabledKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item instanceof SemanticHighlightingColorListItem) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)item).getEnableKey()));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        return this.createSyntaxPage(parent);
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public void initialize() {
        super.initialize();
        this.fListViewer.setInput((Object)this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.fRubyCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleSyntaxColorListSelection();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fSyntaxBackgroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getBackgroundKey());
        this.fSyntaxBackgroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
            this.fEnableBackgroundCheckbox.setEnabled(enable);
            boolean bgEnabled = this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getBackgroundEnabledKey());
            this.fEnableBackgroundCheckbox.setSelection(bgEnabled);
            this.fSyntaxBackgroundColorEditor.getButton().setEnabled(bgEnabled);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
            this.fEnableBackgroundCheckbox.setEnabled(true);
            boolean bgEnabled = this.getPreferenceStore().getBoolean(item.getBackgroundEnabledKey());
            this.fEnableBackgroundCheckbox.setSelection(bgEnabled);
            this.fSyntaxBackgroundColorEditor.getButton().setEnabled(bgEnabled);
        }
    }

    private Control createSyntaxPage(final Composite parent) {
        Composite colorComposite;
        this.fComposite = colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        Link link = new Link(colorComposite, 0);
        link.setText(PreferencesMessages.RubyEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(colorComposite, 1);
        Composite group = this.createComposite(colorComposite, 4);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 4;
        group.setLayoutData((Object)groupData);
        this.fLoadButton = RubyEditorColoringConfigurationBlock.createButton(group, "Import", 128);
        this.fSaveButton = RubyEditorColoringConfigurationBlock.createButton(group, "Export", 128);
        new ButtonController();
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.RubyEditorPreferencePage_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fListViewer = new TreeViewer(editorComposite, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fListViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (RubyEditorColoringConfigurationBlock.this.fRubyCategory.equals(element)) {
                    return 0;
                }
                return 0;
            }
        });
        gd = new GridData(1, 1, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        for (HighlightingColorListItem item : this.fListModel) {
            maxWidth = Math.max(maxWidth, this.convertWidthInCharsToPixels(item.getDisplayName().length()));
        }
        ScrollBar vBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 3;
        }
        gd.widthHint = maxWidth;
        this.fListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.RubyEditorPreferencePage_enable);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.RubyEditorPreferencePage_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fEnableBackgroundCheckbox = new Button(stylesComposite, 16416);
        this.fEnableBackgroundCheckbox.setText(PreferencesMessages.RubyEditorPreferencePage_background_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fEnableBackgroundCheckbox.setLayoutData((Object)gd);
        this.fEnableBackgroundCheckbox.setEnabled(false);
        this.fSyntaxBackgroundColorEditor = new ColorSelector(stylesComposite);
        Button backgroundColorButton = this.fSyntaxBackgroundColorEditor.getButton();
        gd = new GridData(32);
        backgroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.RubyEditorPreferencePage_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.RubyEditorPreferencePage_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RubyEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)RubyEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)RubyEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        backgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)RubyEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getBackgroundKey(), (RGB)RubyEditorColoringConfigurationBlock.this.fSyntaxBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), RubyEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), RubyEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), RubyEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), RubyEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = RubyEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    RubyEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    RubyEditorColoringConfigurationBlock.this.fEnableBackgroundCheckbox.setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fSyntaxBackgroundColorEditor.getButton().setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    RubyEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                }
            }
        });
        this.fEnableBackgroundCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = RubyEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                boolean enable = RubyEditorColoringConfigurationBlock.this.fEnableBackgroundCheckbox.getSelection();
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBackgroundEnabledKey(), enable);
                RubyEditorColoringConfigurationBlock.this.fSyntaxBackgroundColorEditor.getButton().setEnabled(enable);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        colorComposite.layout(false);
        return colorComposite;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = new RubySourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        SimpleRubySourceViewerConfiguration configuration = new SimpleRubySourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, "___ruby_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new RubySourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        RubyPlugin.getDefault().getRubyTextTools().setupRubyDocumentPartitioner((IDocument)document, "___ruby_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences result = new Preferences();
        result.setValue(COMPILER_TASK_TAGS, "TASK,TODO");
        return result;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    RubyPlugin.log(io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fListViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)element;
    }

    private void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private class ButtonController
    implements SelectionListener {
        public ButtonController() {
            RubyEditorColoringConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            RubyEditorColoringConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == RubyEditorColoringConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == RubyEditorColoringConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            }
        }

        private void loadButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(RubyEditorColoringConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText("Load Profile");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = RubyPlugin.getDefault().getDialogSettings().get(RubyEditorColoringConfigurationBlock.DIALOGSTORE_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            RubyPlugin.getDefault().getDialogSettings().put(RubyEditorColoringConfigurationBlock.DIALOGSTORE_LASTLOADPATH, dialog.getFilterPath());
            File file = new File(path);
            Map<String, String> profiles = null;
            try {
                profiles = SyntaxColoringStore.readFromFile(file);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, RubyEditorColoringConfigurationBlock.this.fComposite.getShell(), "Import Profile", "Could not import the profile");
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            for (String key : profiles.keySet()) {
                RubyEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(key, profiles.get(key));
            }
            RubyEditorColoringConfigurationBlock.this.performDefaults();
        }

        private void saveButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(RubyEditorColoringConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText("Export profile");
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = RubyPlugin.getDefault().getDialogSettings().get(RubyEditorColoringConfigurationBlock.DIALOGSTORE_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            RubyPlugin.getDefault().getDialogSettings().put(RubyEditorColoringConfigurationBlock.DIALOGSTORE_LASTSAVEPATH, dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)RubyEditorColoringConfigurationBlock.this.fComposite.getShell(), (String)"Export profile", (String)Messages.format("{0} already exists. Do you want to replace it?", path))) {
                return;
            }
            try {
                SyntaxColoringStore.write(RubyEditorColoringConfigurationBlock.this.fListModel, file);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, RubyEditorColoringConfigurationBlock.this.fComposite.getShell(), "Export Profile", "Could not export the profiles.");
            }
        }
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new String[]{RubyEditorColoringConfigurationBlock.this.fRubyCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                if (RubyEditorColoringConfigurationBlock.this.fRubyCategory.equals(entry)) {
                    return RubyEditorColoringConfigurationBlock.this.fListModel.toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            return RubyEditorColoringConfigurationBlock.this.fRubyCategory;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((HighlightingColorListItem)element).getDisplayName();
        }
    }

    public static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fBackgroundKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;
        private String fBackgroundEnabledKey;

        public HighlightingColorListItem(String displayName, String colorKey, String bgColorKey, String bgEnabledKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBackgroundKey = bgColorKey;
            this.fBackgroundEnabledKey = bgEnabledKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getBackgroundKey() {
            return this.fBackgroundKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public String getBackgroundEnabledKey() {
            return this.fBackgroundEnabledKey;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String bgColorKey, String bgEnabledKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String enableKey) {
            super(displayName, colorKey, bgColorKey, bgEnabledKey, boldKey, italicKey, strikethroughKey, underlineKey);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }
}

