/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;

class RubySourcePreviewerUpdater {
    RubySourcePreviewerUpdater(final SourceViewer viewer, final RubySourceViewerConfiguration configuration, final IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)((Object)configuration));
        Assert.isNotNull((Object)preferenceStore);
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.rubypeople.rdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
                    viewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (configuration.affectsTextPresentation(event)) {
                    configuration.handlePropertyChangeEvent(event);
                    viewer.invalidateTextPresentation();
                }
            }
        };
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                preferenceStore.removePropertyChangeListener(propertyChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
    }
}

