/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyPreview;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyScriptPreview;

public class CommentsTabPage
extends ModifyDialogTabPage {
    private static final String PREVIEW = String.valueOf(CommentsTabPage.createPreviewHeader("An example for comment formatting. This example is meant to illustrate the various possibilities offered by <i>Eclipse</i> in order to format comments.")) + "require 'open-uri'\n" + "#\n" + "# This is the comment for the example module.\n" + "#\n" + " module Example\n" + " #\n" + " #\n" + " # These possibilities include:\n" + " # * Formatting of header comments. * Formatting of Rdoc tags\n" + " #\n" + " def self.bar; puts 'hello bar'; end\n" + " #\n" + " # The following is some sample code which illustrates source formatting within Rdoc comments:\n" + " # <tt>class Example\n# @a= 1\n# @b= true\n# end</tt>\n" + " #\n" + " def foo(a, b); puts a + b; end\n" + "end";
    private RubyScriptPreview fPreview;

    public CommentsTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group globalGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group1_title);
        ModifyDialogTabPage.CheckboxPreference global = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_comment_formatting, "org.rubypeople.rdt.core.formatter.comment.format_comments");
        Group settingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group2_title);
        ModifyDialogTabPage.CheckboxPreference blankComments = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_clear_blank_lines, "org.rubypeople.rdt.core.formatter.comment.clear_blank_lines");
        Group widthGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group3_title);
        ModifyDialogTabPage.NumberPreference lineWidth = this.createNumberPref((Composite)widthGroup, numColumns, FormatterMessages.CommentsTabPage_line_width, "org.rubypeople.rdt.core.formatter.comment.line_length", 0, 9999);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> masters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        masters.add(global);
        ArrayList<Object> slaves = new ArrayList<Object>();
        slaves.add(settingsGroup);
        slaves.add(blankComments);
        slaves.add(lineWidth);
        new Controller(masters, slaves);
        masters = new ArrayList();
        masters.add(global);
        slaves = new ArrayList();
        new Controller(masters, slaves);
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected RubyPreview doCreateRubyPreview(Composite parent) {
        this.fPreview = new RubyScriptPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefTrueFalse(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, FALSE_TRUE);
    }

    private static final class Controller
    implements Observer {
        private final Collection fMasters;
        private final Collection fSlaves;

        public Controller(Collection masters, Collection slaves) {
            this.fMasters = masters;
            this.fSlaves = slaves;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                ((ModifyDialogTabPage.CheckboxPreference)iter.next()).addObserver(this);
            }
            this.update(null, null);
        }

        public void update(Observable o, Object arg) {
            boolean enabled = true;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                enabled &= ((ModifyDialogTabPage.CheckboxPreference)iter.next()).getChecked();
            }
            for (Object obj : this.fSlaves) {
                if (obj instanceof ModifyDialogTabPage.Preference) {
                    ((ModifyDialogTabPage.Preference)obj).setEnabled(enabled);
                    continue;
                }
                if (!(obj instanceof Control)) continue;
                ((Group)obj).setEnabled(enabled);
            }
        }
    }
}

