/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyPreview;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyScriptPreview;

public class IndentationTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "class Example\n" + "  @@my_hash= {1 => 'one', 2 => 'two',3 => 'three'}\n" + "  @@my_array= [1,2,3,4,5,6]\n" + "  MY_CONST= 1\n" + "  $some_string= \"Hello\"\n" + "  a_float= 3.0\n" + "  def foo(a, b, c, d, e, f)\n" + "    case a\n" + "    when 0\n" + "      Other.foo\n" + "    else\n" + "      Other.baz\n" + "    end\n" + "  end\n" + "  def bar(v)\n" + "    for i in 0...10 do\n" + "      v << i\n" + "    end\n" + "  end\n" + "end\n" + "\n" + "module MyModule\n" + "end";
    private RubyScriptPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.rubypeople.rdt.core.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.rubypeople.rdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.rubypeople.rdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.rubypeople.rdt.core.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.char");
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "org.rubypeople.rdt.core.formatter.indent_case_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.rubypeople.rdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected RubyPreview doCreateRubyPreview(Composite parent) {
        this.fPreview = new RubyScriptPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.rubypeople.rdt.core.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if ("space".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.rubypeople.rdt.core.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("tab".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        Object tabSize = this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.size");
        Object indentSize = this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.rubypeople.rdt.core.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("org.rubypeople.rdt.core.formatter.indentation.size", tabSize);
    }
}

