/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class EditorHighlightingSynchronizer
implements ILinkedModeListener {
    private final RubyEditor fEditor;
    private final boolean fWasOccurrencesOn;

    public EditorHighlightingSynchronizer(RubyEditor editor) {
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        this.fEditor = editor;
        this.fWasOccurrencesOn = this.fEditor.isMarkingOccurrences();
        if (this.fWasOccurrencesOn && !this.isEditorDisposed()) {
            this.fEditor.uninstallOccurrencesFinder();
        }
    }

    public void left(LinkedModeModel environment, int flags) {
        if (this.fWasOccurrencesOn && !this.isEditorDisposed()) {
            this.fEditor.installOccurrencesFinder(true);
        }
    }

    private boolean isEditorDisposed() {
        return this.fEditor == null || this.fEditor.getSelectionProvider() == null;
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }
}

