/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.rubypeople.rdt.core.LocalFileStorage;

public class ExternalRubyFileEditorInput
implements IStorageEditorInput,
ILocationProvider,
IPersistableElement {
    private LocalFileStorage storage;

    public ExternalRubyFileEditorInput(File file) {
        this.storage = new LocalFileStorage(file);
    }

    public ExternalRubyFileEditorInput(LocalFileStorage file) {
        this.storage = file;
    }

    public boolean exists() {
        return this.storage.getFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getFile().getName();
    }

    public void saveState(IMemento memento) {
        memento.putString("path", this.storage.getFile().getAbsolutePath());
    }

    public String getFactoryId() {
        return "org.rubypeople.rdt.ui.externalRubyFileEditorInputFactory";
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.storage.getFile().getAbsolutePath();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof ExternalRubyFileEditorInput) {
            ExternalRubyFileEditorInput input = (ExternalRubyFileEditorInput)element;
            return new Path(input.getFilesystemFile().getAbsolutePath());
        }
        return null;
    }

    public File getFilesystemFile() {
        return this.storage.getFile();
    }

    public boolean equals(Object object) {
        return object instanceof ExternalRubyFileEditorInput && this.getStorage().equals(((ExternalRubyFileEditorInput)object).getStorage());
    }

    public int hashCode() {
        return this.getStorage().hashCode();
    }
}

