/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.PartInitException;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.text.ruby.IRubyReconcilingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverrideIndicatorManager
implements IRubyReconcilingListener {
    static final String ANNOTATION_TYPE = "org.rubypeople.rdt.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;

    public OverrideIndicatorManager(IAnnotationModel annotationModel, IRubyElement rubyElement, Node ast) {
        Assert.isNotNull((Object)annotationModel);
        Assert.isNotNull((Object)rubyElement);
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        if (ast != null) {
            this.updateAnnotations((IRubyScript)rubyElement, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(IRubyScript ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        HashMap<OverrideIndicator, Position> annotationMap = new HashMap<OverrideIndicator, Position>(50);
        try {
            IType[] types = ast.getAllTypes();
            int i = 0;
            while (i < types.length) {
                ITypeHierarchy hierarchy;
                IMethod[] methods = types[i].getMethods();
                List<IMethod> filtered = this.filterToPublic(methods);
                if (!filtered.isEmpty() && (hierarchy = types[i].newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())) != null) {
                    IType[] supers = hierarchy.getAllTypes();
                    for (IMethod method : filtered) {
                        int k = 0;
                        while (k < supers.length) {
                            if (!supers[k].equals(types[i])) {
                                IMethod[] superMethods = supers[k].getMethods();
                                int l = 0;
                                while (l < superMethods.length) {
                                    IMethod overridenMethod = superMethods[l];
                                    if (overridenMethod.getElementName().equals(method.getElementName())) {
                                        Position position = new Position(method.getSourceRange().getOffset(), method.getSourceRange().getLength());
                                        String qualifiedMethodName = String.valueOf(overridenMethod.getDeclaringType().getFullyQualifiedName()) + "." + overridenMethod.getElementName();
                                        String text = Messages.format(RubyEditorMessages.OverrideIndicatorManager_overrides, qualifiedMethodName);
                                        annotationMap.put(new OverrideIndicator(false, text, overridenMethod.getHandleIdentifier()), position);
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    private List<IMethod> filterToPublic(IMethod[] methods) {
        ArrayList<IMethod> filtered = new ArrayList<IMethod>();
        if (methods == null || methods.length == 0) {
            return filtered;
        }
        int i = 0;
        while (i < methods.length) {
            try {
                if (methods[i].isPublic()) {
                    filtered.add(methods[i]);
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            ++i;
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(IRubyScript script, RootNode ast, boolean forced, IProgressMonitor progressMonitor) {
        this.updateAnnotations(script, progressMonitor);
    }

    class OverrideIndicator
    extends Annotation {
        private boolean fIsOverwriteIndicator;
        private String fHandleIdentifier;

        OverrideIndicator(boolean isOverwriteIndicator, String text, String handleIdentifier) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fIsOverwriteIndicator = isOverwriteIndicator;
            this.fHandleIdentifier = handleIdentifier;
        }

        public boolean isOverwriteIndicator() {
            return this.fIsOverwriteIndicator;
        }

        public void open() {
            try {
                OpenActionUtil.open(RubyCore.create((String)this.fHandleIdentifier), true);
            }
            catch (PartInitException e) {
                RubyPlugin.log(e);
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
    }
}

