/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ExternalRubyScript;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyOutlinePage;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.search.IOccurrencesFinder;
import org.rubypeople.rdt.internal.ui.search.OccurrencesFinder;
import org.rubypeople.rdt.internal.ui.text.ContentAssistPreference;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.RubyPairMatcher;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;
import org.rubypeople.rdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.rubypeople.rdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.rubyeditor.ICustomRubyOutlinePage;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyAbstractEditor
extends TextEditor {
    private static final boolean CODE_ASSIST_DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.rubypeople.rdt.ui/debug/ResultCollector"));
    protected RubyTextTools textTools;
    private ISourceReference reference;
    protected String fOutlinerContextMenuId;
    protected AbstractTextEditor.AbstractSelectionChangedListener fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    private ICustomRubyOutlinePage fOutlinePage;
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private static final String CUSTOM_OUTLINE_EXTPOINT_ID = "customRubyOutlinePages";
    protected RubyPairMatcher fBracketMatcher = new RubyPairMatcher(BRACKETS);
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkMethodOccurrences;
    private boolean fMarkConstantOccurrences;
    private boolean fMarkFieldOccurrences;
    private boolean fMarkLocalVariableOccurrences;
    private boolean fMarkMethodExitPoints;
    private ISelection fForcedMarkOccurrencesSelection;
    private long fMarkOccurrenceModificationStamp = -1L;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private IRegion fMarkOccurrenceTargetRegion;

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        IRubyProject project = EditorUtility.getRubyProject(input);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.rubypeople.rdt.core"));
        }
        stores.add(RubyPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(RubyCore.getPlugin().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        IPreferenceStore store = this.getPreferenceStore();
        ISourceViewer viewer = this.createRubySourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
        this.getSourceViewerDecorationSupport(viewer);
        return viewer;
    }

    protected ISourceViewer createRubySourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new AdaptedSourceViewer(parent, verticalRuler, overviewRuler, isOverviewRulerVisible, styles, store);
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(store);
        RubyTextTools textTools = RubyPlugin.getDefault().getRubyTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new RubySourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___ruby_partitioning"));
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkMethodOccurrences = store.getBoolean("markMethodOccurrences");
        this.fMarkConstantOccurrences = store.getBoolean("markConstantOccurrences");
        this.fMarkFieldOccurrences = store.getBoolean("markFieldOccurrences");
        this.fMarkLocalVariableOccurrences = store.getBoolean("markLocalVariableOccurrences");
        this.fMarkMethodExitPoints = store.getBoolean("markMethodExitPoints");
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.getSourceViewerConfiguration() instanceof RubySourceViewerConfiguration) {
            RubyTextTools textTools = RubyPlugin.getDefault().getRubyTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new RubySourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___ruby_partitioning"));
        }
        if (this.getSourceViewer() instanceof RubySourceViewer) {
            ((RubySourceViewer)this.getSourceViewer()).setPreferenceStore(store);
        }
    }

    public void dispose() {
        super.dispose();
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createRubyOutlinePage();
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fMarkOccurrenceAnnotations) {
            this.installOccurrencesFinder(false);
        }
    }

    protected ICustomRubyOutlinePage createRubyOutlinePage() {
        IRubyElement element = this.getInputRubyElement();
        RubyOutlinePage outlinePage = null;
        List<ICustomRubyOutlinePage> customPages = this.getCustomOutlines();
        for (ICustomRubyOutlinePage customRubyOutlinePage : customPages) {
            if (!customRubyOutlinePage.isEnabled(element)) continue;
            customRubyOutlinePage.init(this.fOutlinerContextMenuId, this);
            outlinePage = (RubyOutlinePage)customRubyOutlinePage;
            break;
        }
        if (outlinePage == null) {
            outlinePage = new RubyOutlinePage();
            outlinePage.init(this.fOutlinerContextMenuId, this);
        }
        this.fOutlineSelectionChangedListener.install((ISelectionProvider)outlinePage);
        this.setOutlinePageInput(outlinePage, this.getEditorInput());
        return outlinePage;
    }

    private List<ICustomRubyOutlinePage> getCustomOutlines() {
        ArrayList<ICustomRubyOutlinePage> list = new ArrayList<ICustomRubyOutlinePage>();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.ui", CUSTOM_OUTLINE_EXTPOINT_ID);
        if (extension == null) {
            return list;
        }
        IExtension[] extensions = extension.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configElement = configElements[j];
                String elementName = configElement.getName();
                if ("page".equals(elementName)) {
                    try {
                        ICustomRubyOutlinePage customPage = (ICustomRubyOutlinePage)configElement.createExecutableExtension("class");
                        list.add(customPage);
                    }
                    catch (CoreException e) {
                        RubyPlugin.log(e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IProject[] projects;
        Method method;
        IPath path = null;
        if (this.externalFileOpenedInEclipse32(input)) {
            try {
                method = input.getClass().getDeclaredMethod("getPath", new Class[0]);
                if (method != null) {
                    path = (IPath)method.invoke((Object)input, new Object[0]);
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (this.externalFileOpenedInEclipse33(input)) {
            try {
                URI uri;
                method = input.getClass().getDeclaredMethod("getURI", new Class[0]);
                if (method != null && (uri = (URI)method.invoke((Object)input, new Object[0])) != null && uri.getScheme().equals("file")) {
                    path = new Path(uri.getPath());
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (path != null && (this.externalFileOpenedInEclipse32(input) || this.externalFileOpenedInEclipse33(input)) && (projects = RubyCore.getRubyProjects()) != null && projects.length > 0) {
            IRubyProject proj = RubyCore.create((IProject)projects[0]);
            ISourceFolderRoot root = proj.getSourceFolderRoot(path.removeLastSegments(1).toPortableString());
            ISourceFolder folder = root.getSourceFolder("");
            IRubyScript script = folder.getRubyScript(path.lastSegment());
            input = new RubyScriptEditorInput((ExternalRubyScript)script);
        }
        if (input instanceof IRubyScriptEditorInput) {
            this.setDocumentProvider((IDocumentProvider)RubyPlugin.getDefault().getExternalDocumentProvider());
        } else {
            this.setDocumentProvider(RubyPlugin.getDefault().getRubyDocumentProvider());
        }
        super.doSetInput(input);
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    private boolean externalFileOpenedInEclipse33(IEditorInput input) {
        return input.getClass().getName().equals("org.eclipse.ui.ide.FileStoreEditorInput");
    }

    private boolean externalFileOpenedInEclipse32(IEditorInput input) {
        return input.getClass().getName().equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput");
    }

    protected void setOutlinePageInput(ICustomRubyOutlinePage page, IEditorInput input) {
        if (page == null) {
            return;
        }
        IRubyElement re = this.getInputRubyElement();
        if (re != null && re.exists()) {
            page.setInput(re);
        } else {
            page.setInput(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            return;
        }
        try {
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if ("markOccurrences".equals(property)) {
                if (newBooleanValue == this.fMarkOccurrenceAnnotations) return;
                this.fMarkOccurrenceAnnotations = newBooleanValue;
                if (!this.fMarkOccurrenceAnnotations) {
                    this.uninstallOccurrencesFinder();
                    return;
                }
                this.installOccurrencesFinder(true);
                return;
            }
            if ("markTypeOccurrences".equals(property)) {
                this.fMarkTypeOccurrences = newBooleanValue;
                return;
            }
            if ("markMethodOccurrences".equals(property)) {
                this.fMarkMethodOccurrences = newBooleanValue;
                return;
            }
            if ("markConstantOccurrences".equals(property)) {
                this.fMarkConstantOccurrences = newBooleanValue;
                return;
            }
            if ("markFieldOccurrences".equals(property)) {
                this.fMarkFieldOccurrences = newBooleanValue;
                return;
            }
            if ("markLocalVariableOccurrences".equals(property)) {
                this.fMarkLocalVariableOccurrences = newBooleanValue;
                return;
            }
            if ("markMethodExitPoints".equals(property)) {
                this.fMarkMethodExitPoints = newBooleanValue;
                return;
            }
            if ("stickyOccurrences".equals(property)) {
                this.fStickyOccurrenceAnnotations = newBooleanValue;
                return;
            }
            AdaptedSourceViewer sourceViewer = (AdaptedSourceViewer)this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            ((RubySourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(event);
            IContentAssistant c = sourceViewer.getContentAssistant();
            if (c instanceof ContentAssistant) {
                ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
        if (!"show_range_indicator".equals(property)) return;
        Object newValue = event.getNewValue();
        ISourceViewer viewer = this.getSourceViewer();
        if (newValue == null) return;
        if (viewer == null) return;
        if (Boolean.valueOf(newValue.toString()) == false) return;
        Point selection = viewer.getSelectedRange();
        this.adjustHighlightRange(selection.x, selection.y);
    }

    protected IRubyElement getInputRubyElement() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return RubyUI.getEditorInputRubyElement(this.getEditorInput());
    }

    protected void handleOutlinePageSelection(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        for (Object o : selection) {
            if (!(o instanceof ISourceReference)) continue;
            this.reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && RubyPlugin.getActivePage() != null) {
            RubyPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(this.reference, true);
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals((Object)this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    public void setSelection(IRubyElement element) {
        if (element == null || element instanceof IRubyScript) {
            return;
        }
        IRubyElement corresponding = this.getCorrespondingElement(element);
        if (corresponding instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)corresponding;
            this.setSelection(reference, true);
            if (this.fOutlinePage != null) {
                this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
                this.fOutlinePage.select(reference);
                this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
            }
        }
    }

    protected IRubyElement getCorrespondingElement(IRubyElement element) {
        return element;
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || element == null || checkIfOutlinePageActive && this.isRubyOutlinePageActive())) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage.select(element);
            this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
        }
    }

    private boolean isRubyOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block21: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    String content;
                    String name;
                    ISourceRange range = null;
                    range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember) {
                        range = ((IMember)reference).getNameRange();
                        if (range != null) {
                            offset = range.getOffset();
                            length = range.getLength();
                        }
                    } else if (reference instanceof IImportDeclaration && (name = ((IImportDeclaration)reference).getElementName()) != null && name.length() > 0 && (content = reference.getSource()) != null) {
                        offset = range.getOffset() + content.indexOf(name);
                        length = name.length();
                    }
                    if (offset <= -1 || length <= 0) break block21;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (RubyModelException rubyModelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((RubySourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        ISourceReference reference = null;
        ISelection selection = event.getSelection();
        for (Object o : (IStructuredSelection)selection) {
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && RubyPlugin.getActivePage() != null) {
            RubyPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(reference, !this.isActivePart());
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IRubyElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 8) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (RubyModelException rubyModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    protected abstract IRubyElement getElementAt(int var1, boolean var2);

    protected abstract IRubyElement getElementAt(int var1);

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, RootNode ast) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (selection == null) {
            return;
        }
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            if (this.fMarkOccurrenceTargetRegion != null && currentModificationStamp == this.fMarkOccurrenceModificationStamp && this.fMarkOccurrenceTargetRegion.getOffset() <= offset && offset <= this.fMarkOccurrenceTargetRegion.getOffset() + this.fMarkOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = RubyWordFinder.findWord(document, offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        document.get();
        OccurrencesFinder finder = new OccurrencesFinder();
        finder.setFMarkConstantOccurrences(this.fMarkConstantOccurrences);
        finder.setFMarkFieldOccurrences(this.fMarkFieldOccurrences);
        finder.setFMarkLocalVariableOccurrences(this.fMarkLocalVariableOccurrences);
        finder.setFMarkMethodExitPoints(this.fMarkMethodExitPoints);
        finder.setFMarkMethodOccurrences(this.fMarkMethodOccurrences);
        finder.setFMarkOccurrenceAnnotations(this.fMarkOccurrenceAnnotations);
        finder.setFMarkTypeOccurrences(this.fMarkTypeOccurrences);
        finder.setFStickyOccurrenceAnnotations(this.fStickyOccurrenceAnnotations);
        finder.initialize((Node)ast, selection.getOffset(), selection.getLength());
        List<Position> matches = finder.perform();
        if (matches == null || matches.isEmpty()) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        Position[] positions = matches.toArray(new Position[matches.size()]);
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, positions, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected void setMarkOccurrencePreferences(IOccurrencesFinder occurrencesFinder) {
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, RootNode astRoot) {
                RubyAbstractEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, RubyPlugin.getDefault().getASTProvider().getAST(this.getInputRubyElement(), ASTProvider.WAIT_NO, this.getProgressMonitor()));
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected boolean isMarkingOccurrences() {
        return this.fMarkOccurrenceAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == RubyAbstractEditor.this.getEditorSite().getWorkbenchWindow() && RubyAbstractEditor.this.fMarkOccurrenceAnnotations && RubyAbstractEditor.this.isActivePart()) {
                RubyAbstractEditor.this.fForcedMarkOccurrencesSelection = RubyAbstractEditor.this.getSelectionProvider().getSelection();
                RubyAbstractEditor.this.updateOccurrenceAnnotations((ITextSelection)RubyAbstractEditor.this.fForcedMarkOccurrencesSelection, RubyPlugin.getDefault().getASTProvider().getAST(RubyAbstractEditor.this.getInputRubyElement(), ASTProvider.WAIT_NO, RubyAbstractEditor.this.getProgressMonitor()));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == RubyAbstractEditor.this.getEditorSite().getWorkbenchWindow() && RubyAbstractEditor.this.fMarkOccurrenceAnnotations && RubyAbstractEditor.this.isActivePart()) {
                RubyAbstractEditor.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    class AdaptedSourceViewer
    extends RubySourceViewer {
        private List fTextConverters;
        private boolean fIgnoreTextConverters;

        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
            this.fIgnoreTextConverters = false;
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public void addTextConverter(RubyEditor.ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(RubyEditor.ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((RubyEditor.ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = RubyAbstractEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    long time = CODE_ASSIST_DEBUG ? System.currentTimeMillis() : 0L;
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    if (CODE_ASSIST_DEBUG) {
                        long delta = System.currentTimeMillis() - time;
                        System.err.println("Code Assist (total): " + delta);
                    }
                    RubyAbstractEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 22: {
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    RubyAbstractEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                    super.doOperation(operation);
                    this.fIgnoreTextConverters = false;
                    return;
                }
            }
            super.doOperation(operation);
        }
    }

    private static class EclipsePreferencesAdapter
    implements IPreferenceStore {
        private ListenerList fListeners = new ListenerList();
        private IEclipsePreferences.IPreferenceChangeListener fListener = new PreferenceChangeListener();
        private final IScopeContext fContext;
        private final String fQualifier;

        public EclipsePreferencesAdapter(IScopeContext context, String qualifier) {
            this.fContext = context;
            this.fQualifier = qualifier;
        }

        private IEclipsePreferences getNode() {
            return this.fContext.getNode(this.fQualifier);
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            if (this.fListeners.size() == 0) {
                this.getNode().addPreferenceChangeListener(this.fListener);
            }
            this.fListeners.add((Object)listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.size() == 0) {
                this.getNode().removePreferenceChangeListener(this.fListener);
            }
        }

        public boolean contains(String name) {
            return this.getNode().get(name, null) != null;
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }

        public boolean getBoolean(String name) {
            return this.getNode().getBoolean(name, false);
        }

        public boolean getDefaultBoolean(String name) {
            return false;
        }

        public double getDefaultDouble(String name) {
            return 0.0;
        }

        public float getDefaultFloat(String name) {
            return 0.0f;
        }

        public int getDefaultInt(String name) {
            return 0;
        }

        public long getDefaultLong(String name) {
            return 0L;
        }

        public String getDefaultString(String name) {
            return "";
        }

        public double getDouble(String name) {
            return this.getNode().getDouble(name, 0.0);
        }

        public float getFloat(String name) {
            return this.getNode().getFloat(name, 0.0f);
        }

        public int getInt(String name) {
            return this.getNode().getInt(name, 0);
        }

        public long getLong(String name) {
            return this.getNode().getLong(name, 0L);
        }

        public String getString(String name) {
            return this.getNode().get(name, "");
        }

        public boolean isDefault(String name) {
            return false;
        }

        public boolean needsSaving() {
            try {
                return this.getNode().keys().length > 0;
            }
            catch (BackingStoreException backingStoreException) {
                return true;
            }
        }

        public void putValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, String defaultObject) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        public void setToDefault(String name) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        private class PreferenceChangeListener
        implements IEclipsePreferences.IPreferenceChangeListener {
            private PreferenceChangeListener() {
            }

            public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                        }
                    });
                } else {
                    EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                }
            }
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private IDocument fDocument;
        private ISelection fSelection;
        private ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private IProgressMonitor fProgressMonitor;
        private Position[] fPositions;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super("OccurrencesFinderJob");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (RubyAbstractEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)RubyAbstractEditor.this.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && RubyAbstractEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = RubyAbstractEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = RubyAbstractEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)RubyAbstractEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block16: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block16;
                    }
                    annotationMap.put(new Annotation("org.rubypeople.rdt.ui.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object object = RubyAbstractEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(RubyAbstractEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    RubyAbstractEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                RubyAbstractEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = RubyAbstractEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = RubyAbstractEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = RubyAbstractEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)RubyAbstractEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (RubyAbstractEditor.this.fOccurrencesFinderJob != null) {
                RubyAbstractEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    class OutlineSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        OutlineSelectionChangedListener() {
            super((AbstractTextEditor)RubyAbstractEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean isLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.SyncOutlineOnCursorMove");
            if (isLinkingEnabled) {
                RubyAbstractEditor.this.doSelectionChanged(event);
            }
        }
    }
}

