/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionProcessor;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RubyAnnotationImageProvider
implements IAnnotationImageProvider {
    private static final int NO_IMAGE = 0;
    private static final int GRAY_IMAGE = 1;
    private static final int OVERLAY_IMAGE = 2;
    private static final int QUICKFIX_IMAGE = 3;
    private static final int QUICKFIX_ERROR_IMAGE = 4;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static ImageRegistry fgImageRegistry;
    private boolean fShowQuickFixIcon = PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.ShowTemporaryProblem");
    private int fCachedImageType;
    private Image fCachedImage;

    public Image getManagedImage(Annotation annotation) {
        if (annotation instanceof IRubyAnnotation) {
            IRubyAnnotation javaAnnotation = (IRubyAnnotation)annotation;
            int imageType = this.getImageType(javaAnnotation);
            return this.getImage(javaAnnotation, imageType, Display.getCurrent());
        }
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return null;
    }

    private boolean showQuickFix(IRubyAnnotation annotation) {
        return this.fShowQuickFixIcon && annotation.isProblem() && RubyCorrectionProcessor.hasCorrections((Annotation)annotation);
    }

    private Image getQuickFixImage() {
        if (fgQuickFixImage == null) {
            fgQuickFixImage = RubyPluginImages.get("org.rubypeople.rdt.ui.quickfix_warning_obj.gif");
        }
        return fgQuickFixImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = RubyPluginImages.get("org.rubypeople.rdt.ui.quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    private ImageRegistry getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry(display);
        }
        return fgImageRegistry;
    }

    private int getImageType(IRubyAnnotation annotation) {
        int imageType = 0;
        if (annotation.hasOverlay()) {
            imageType = 2;
        } else if (!annotation.isMarkedDeleted()) {
            if (this.showQuickFix(annotation)) {
                imageType = "org.rubypeople.rdt.ui.error".equals(annotation.getType()) ? 4 : 3;
            }
        } else {
            imageType = 1;
        }
        return imageType;
    }

    private Image getImage(IRubyAnnotation annotation, int imageType, Display display) {
        if ((imageType == 3 || imageType == 4) && this.fCachedImageType == imageType) {
            return this.fCachedImage;
        }
        Image image = null;
        switch (imageType) {
            case 2: {
                IRubyAnnotation overlay = annotation.getOverlay();
                image = this.getManagedImage((Annotation)overlay);
                this.fCachedImageType = -1;
                break;
            }
            case 3: {
                image = this.getQuickFixImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 4: {
                image = this.getQuickFixErrorImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 1: {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                String annotationType = annotation.getType();
                if ("org.rubypeople.rdt.ui.error".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if ("org.rubypeople.rdt.ui.warning".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if ("org.rubypeople.rdt.ui.info".equals(annotationType)) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
                if (image != null) {
                    String key;
                    ImageRegistry registry = this.getImageRegistry(display);
                    Image grayImage = registry.get(key = Integer.toString(image.hashCode()));
                    if (grayImage == null) {
                        grayImage = new Image((Device)display, image, 2);
                        registry.put(key, grayImage);
                    }
                    image = grayImage;
                }
                this.fCachedImageType = -1;
            }
        }
        return image;
    }
}

