/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.ISavePolicy;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyMarkerAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptAnnotationModelEvent;
import org.rubypeople.rdt.internal.ui.text.ruby.IProblemRequestorExtension;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RubyDocumentProvider
extends TextFileDocumentProvider
implements IRubyScriptDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;

    public RubyDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (RubyDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    RubyDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new RubyScriptAnnotationModel((IResource)file);
    }

    protected IRubyScript createRubyScript(IFile file) {
        IRubyScript element = RubyCore.create((IFile)file);
        if (element instanceof IRubyScript) {
            return element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new RubyScriptInfo();
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsHandlingTemporaryProblems(enable);
        }
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        IProject iProject;
        IProblemRequestor requestor;
        if (!(element instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        IRubyScript original = this.createRubyScript(input.getFile());
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof RubyScriptInfo)) {
            return null;
        }
        RubyScriptInfo cuInfo = (RubyScriptInfo)info;
        this.setUpSynchronization(cuInfo);
        IProblemRequestor iProblemRequestor = requestor = cuInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)cuInfo.fModel : null;
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(false);
            extension.setIsHandlingTemporaryProblems(this.isHandlingTemporaryProblems());
        }
        if (!RubyProject.hasRubyNature((IProject)(iProject = input.getFile().getProject()))) {
            RubyCore.addRubyNature((IProject)iProject, null);
        }
        original.becomeWorkingCopy(requestor, this.getProgressMonitor());
        cuInfo.fCopy = original;
        if (cuInfo.fModel instanceof RubyScriptAnnotationModel) {
            RubyScriptAnnotationModel model = (RubyScriptAnnotationModel)cuInfo.fModel;
            model.setRubyScript(cuInfo.fCopy);
        }
        if (cuInfo.fModel != null) {
            cuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        return cuInfo;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    private void setUpSynchronization(RubyScriptInfo cuInfo) {
        IDocument document = cuInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = cuInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof RubyScriptInfo) {
            RubyScriptInfo cuInfo = (RubyScriptInfo)info;
            try {
                cuInfo.fCopy.discardWorkingCopy();
            }
            catch (RubyModelException x) {
                this.handleCoreException((CoreException)((Object)x), x.getMessage());
            }
            if (cuInfo.fModel != null) {
                cuInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(element, info);
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof RubyScriptInfo) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    RubyDocumentProvider.this.commitWorkingCopy(monitor, element, (RubyScriptInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)info.fElement).getFile();
                        return RubyDocumentProvider.this.computeSchedulingRule((IResource)file);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, RubyScriptInfo info, boolean overwrite) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            IResource r;
            IMarker[] markers;
            IRubyScript unit;
            IProgressMonitor subMonitor;
            block27: {
                subMonitor = this.getSubProgressMonitor(monitor, 50);
                try {
                    try {
                        IRubyScript iRubyScript = info.fCopy;
                        synchronized (iRubyScript) {
                            info.fCopy.reconcile(false, null, subMonitor);
                        }
                    }
                    catch (RubyModelException rubyModelException) {
                        subMonitor.done();
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    subMonitor.done();
                    throw throwable;
                }
                subMonitor.done();
            }
            IDocument document = info.fTextFileBuffer.getDocument();
            IResource resource = info.fCopy.getResource();
            Assert.isTrue((boolean)(resource instanceof IFile));
            if (!resource.exists()) {
                subMonitor = this.getSubProgressMonitor(monitor, 50);
                try {
                    this.createFileFromDocument(subMonitor, (IFile)resource, document);
                }
                finally {
                    subMonitor.done();
                }
                return;
            }
            if (this.fSavePolicy != null) {
                this.fSavePolicy.preSave(info.fCopy);
            }
            try {
                try {
                    subMonitor = this.getSubProgressMonitor(monitor, 50);
                    this.fIsAboutToSave = true;
                    info.fCopy.commitWorkingCopy(overwrite, subMonitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                this.fIsAboutToSave = false;
                subMonitor.done();
            }
            if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                model.updateMarkers(document);
            }
            if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(info.fCopy)) != null && info.fModel instanceof AbstractMarkerAnnotationModel && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                int i = 0;
                while (i < markers.length) {
                    model.updateMarker(document, markers[i], null);
                    ++i;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }

    public IRubyScript getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof RubyScriptInfo) {
            RubyScriptInfo info = (RubyScriptInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    public static class ProblemAnnotation
    extends Annotation
    implements IRubyAnnotation,
    IAnnotationPresentation {
        public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private IRubyScript fRubyScript;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.rubypeople.rdt.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.rubypeople.rdt.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.rubypeople.rdt.ui.error", lookup);
            fgQuickFixImagesInitialized = false;
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, IRubyScript cu) {
            this.fProblem = problem;
            this.fRubyScript = cu;
            if (this.fProblem.isTask()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.rubypeople.rdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.rubypeople.rdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.rubypeople.rdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems()) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = RubyPluginImages.get("org.rubypeople.rdt.ui.warning_obj.gif");
                        fgQuickFixErrorImage = RubyPluginImages.get("org.rubypeople.rdt.ui.error_obj.gif");
                        fgQuickFixImage = RubyPluginImages.get("org.rubypeople.rdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.rubypeople.rdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.rubypeople.rdt.ui.warning".equals(type) || "org.rubypeople.rdt.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IRubyAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IRubyAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IRubyAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public IRubyScript getRubyScript() {
            return this.fRubyScript;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public String getMarkerType() {
            if (this.fProblem instanceof CategorizedProblem) {
                return ((CategorizedProblem)this.fProblem).getMarkerType();
            }
            return null;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class RubyScriptAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private IRubyScript fRubyScript;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private boolean fIsHandlingTemporaryProblems;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public RubyScriptAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setRubyScript(IRubyScript unit) {
            this.fRubyScript = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if (markerType != null && markerType.startsWith("org.rubypeople.rdt")) {
                return new RubyMarkerAnnotation(marker);
            }
            return super.createMarkerAnnotation(marker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new RubyScriptAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        public void beginReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean insideReportingSequence) {
            if (this.fRubyScript != null) {
                ProblemRequestorState state = new ProblemRequestorState();
                state.fInsideReportingSequence = insideReportingSequence;
                state.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(state);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem problem) {
            ProblemRequestorState state;
            if (this.fIsHandlingTemporaryProblems && (state = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                state.fReportedProblems.add(problem);
            }
        }

        public void endReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && !state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState state) {
            int stateCount = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                stateCount = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (stateCount == 0 && this.fIsHandlingTemporaryProblems) {
                this.reportProblems(state.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List reportedProblems) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean temporaryProblemsChanged = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean isCanceled = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (reportedProblems != null && reportedProblems.size() > 0) {
                    Iterator e = reportedProblems.iterator();
                    while (e.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fRubyScript);
                            this.overlayMarkers(position, annotation);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                for (RubyMarkerAnnotation annotation : this.fPreviouslyOverlaid) {
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            RubyMarkerAnnotation annotation;
            if (value instanceof RubyMarkerAnnotation && (annotation = (RubyMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations = null;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public void setIsActive(boolean isActive) {
            this.fIsActive = isActive;
        }

        public void setIsHandlingTemporaryProblems(boolean enable) {
            if (this.fIsHandlingTemporaryProblems != enable) {
                this.fIsHandlingTemporaryProblems = enable;
                if (this.fIsHandlingTemporaryProblems) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAnnotations(Position position) {
            Object object = this.getLockObject();
            synchronized (object) {
                return this.fReverseMap.get(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached == null) {
                    this.fReverseMap.put(position, annotation);
                } else if (cached instanceof List) {
                    List list = (List)cached;
                    list.add(annotation);
                } else if (cached instanceof Annotation) {
                    ArrayList<Object> list = new ArrayList<Object>(2);
                    list.add(cached);
                    list.add(annotation);
                    this.fReverseMap.put(position, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                this.fReverseMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached instanceof List) {
                    List list = (List)cached;
                    list.remove(annotation);
                    if (list.size() == 1) {
                        this.fReverseMap.put(position, list.get(0));
                        list.clear();
                    }
                } else if (cached instanceof Annotation) {
                    this.fReverseMap.remove(position);
                }
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            private ProblemRequestorState() {
            }
        }
    }

    protected static class RubyScriptInfo
    extends TextFileDocumentProvider.FileInfo {
        public IRubyScript fCopy;

        protected RubyScriptInfo() {
        }
    }
}

