/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;

public class RubyMarkerAnnotation
extends MarkerAnnotation
implements IRubyAnnotation {
    public static final String RUBY_MARKER_TYPE_PREFIX = "org.rubypeople.rdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.rubypeople.rdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IRubyAnnotation fOverlay;

    public RubyMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public String[] getArguments() {
        return null;
    }

    public int getId() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return marker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String type = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(type) || ERROR_ANNOTATION_TYPE.equals(type);
    }

    public void setOverlay(IRubyAnnotation RubyAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = RubyAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IRubyAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IRubyAnnotation annotation) {
    }

    public void removeOverlaid(IRubyAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public IRubyScript getRubyScript() {
        IRubyElement element = RubyCore.create((IResource)this.getMarker().getResource());
        if (element instanceof IRubyScript) {
            return (IRubyScript)element;
        }
        return null;
    }

    public String getMarkerType() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return null;
        }
        return MarkerUtilities.getMarkerType((IMarker)this.getMarker());
    }
}

