/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.TogglePresentationAction;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.StatusBarUpdater;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.actions.CustomFiltersActionGroup;
import org.rubypeople.rdt.ui.actions.MemberFilterActionGroup;
import org.rubypeople.rdt.ui.actions.OpenViewActionGroup;
import org.rubypeople.rdt.ui.actions.RubySearchActionGroup;
import org.rubypeople.rdt.ui.rubyeditor.ICustomRubyOutlinePage;

public class RubyOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider,
ICustomRubyOutlinePage {
    static Object[] NO_CHILDREN = new Object[0];
    private boolean fTopLevelTypeOnly;
    private IRubyElement fInput;
    private String fContextMenuID;
    private Menu fMenu;
    private RubyOutlineViewer fOutlineViewer;
    private RubyAbstractEditor fEditor;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private ListenerList fPostSelectionChangedListeners = new ListenerList();
    private Hashtable fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleLinkingAction fToggleLinkingAction;
    private IPropertyChangeListener fPropertyChangeListener;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private CompositeActionGroup fActionGroups;

    public void init(String contextMenuID, RubyAbstractEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.fContextMenuID = contextMenuID;
        this.fEditor = editor;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RubyOutlinePage.this.doPropertyChange(event);
            }
        };
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected IType getMainType(IRubyScript compilationUnit) {
        IType type;
        if (compilationUnit == null) {
            return null;
        }
        String name = compilationUnit.getElementName();
        int index = name.indexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        if ((type = compilationUnit.getType(name = Util.underscoresToCamelCase((String)name))).exists()) {
            return type;
        }
        try {
            IType[] types = compilationUnit.getTypes();
            if (types != null && types.length > 0) {
                return types[0];
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return null;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)listener);
        }
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new LexicalSortingAction());
            this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, "org.rubypeople.rdt.ui.RubyOutlinePage");
            this.fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
            this.fCustomFiltersActionGroup.fillActionBars(actionBars);
            IMenuManager menu = actionBars.getMenuManager();
            menu.add((IContributionItem)new Separator("EndFilterGroup"));
            this.fToggleLinkingAction = new ToggleLinkingAction(this);
            menu.add((IAction)new ClassOnlyAction());
            menu.add((IAction)this.fToggleLinkingAction);
        }
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        this.fOutlineViewer = new RubyOutlineViewer(tree);
        this.fOutlineViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fOutlineViewer.setLabelProvider(this.getLabelProvider());
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        listeners = this.fPostSelectionChangedListeners.getListeners();
        i = 0;
        while (i < listeners.length) {
            this.fPostSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        MenuManager manager = new MenuManager(this.fContextMenuID, this.fContextMenuID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                RubyOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        this.fMenu = manager.createContextMenu((Control)tree);
        tree.setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu(String.valueOf(RubyPlugin.getPluginId()) + ".outline", manager, (ISelectionProvider)this.fOutlineViewer);
        this.updateSelectionProvider(site);
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup(this), new RubySearchActionGroup(this)});
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.fEditor.getAction(ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.fEditor.getAction(ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener(updater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.rubypeople.rdt.ui.RubyOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.registerToolbarActions(actionBars);
        this.fOutlineViewer.setInput(this.fInput);
    }

    protected IBaseLabelProvider getLabelProvider() {
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(0x210000000002L, 1);
        return new DecoratingRubyLabelProvider(lprovider);
    }

    protected ITreeContentProvider getContentProvider() {
        return new ChildrenProvider();
    }

    private void updateSelectionProvider(IPageSite site) {
        IRubyScript cu;
        Object provider = this.fOutlineViewer;
        if (this.fInput != null && (cu = (IRubyScript)this.fInput.getAncestor(4)) != null && !RubyModelUtil.isPrimary(cu)) {
            provider = new EmptySelectionProvider();
        }
        site.setSelectionProvider((ISelectionProvider)provider);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        this.fTogglePresentation.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    public void setInput(IRubyElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.fActions.get(actionID);
    }

    public Object getAdapter(Class key) {
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer"};
                }
            };
        }
        if (key == IShowInTarget.class) {
            return this.getShowInTarget();
        }
        return null;
    }

    protected void addAction(IMenuManager menu, String group, String actionID) {
        IAction action = this.getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action.isEnabled()) {
                IMenuManager subMenu = menu.findMenuUsingPath(group);
                if (subMenu != null) {
                    subMenu.add(action);
                } else {
                    menu.appendToGroup(group, action);
                }
            }
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        RubyPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, RubyOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                ISelection sel = context.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection tsel = (ITextSelection)sel;
                    int offset = tsel.getOffset();
                    IRubyElement element = RubyOutlinePage.this.fEditor.getElementAt(offset);
                    if (element != null) {
                        RubyOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)element));
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public boolean isEnabled(IRubyElement inputElement) {
        return false;
    }

    protected class ChildrenProvider
    implements ITreeContentProvider {
        private Object[] NO_CLASS = new Object[]{new NoClassElement()};
        private ElementChangedListener fListener;

        protected ChildrenProvider() {
        }

        protected boolean matches(IRubyElement element) {
            return element.getElementType() == 13;
        }

        protected IRubyElement[] filter(IRubyElement[] children) {
            boolean hasFilterMatches = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    hasFilterMatches = true;
                    break;
                }
                ++i;
            }
            if (!hasFilterMatches) {
                return children;
            }
            Vector<IRubyElement> v = new Vector<IRubyElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.addElement(children[i2]);
                }
                ++i2;
            }
            Object[] result = new IRubyElement[v.size()];
            v.copyInto(result);
            return result;
        }

        public Object[] getChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        return this.filter(c.getChildren());
                    }
                    catch (RubyModelException x) {
                        if (!RubyPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        RubyPlugin.log(x);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object parent) {
            if (RubyOutlinePage.this.fTopLevelTypeOnly && parent instanceof IRubyScript) {
                try {
                    IType type = RubyOutlinePage.this.getMainType((IRubyScript)parent);
                    return type != null ? type.getChildren() : this.NO_CLASS;
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IRubyElement) {
                IRubyElement e = (IRubyElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        IRubyElement[] children = this.filter(c.getChildren());
                        return children != null && children.length > 0;
                    }
                    catch (RubyModelException x) {
                        if (!RubyPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        RubyPlugin.log(x);
                    }
                }
            }
            return false;
        }

        public boolean isDeleted(Object o) {
            return false;
        }

        public void dispose() {
            if (this.fListener != null) {
                RubyCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof IRubyScript;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                RubyCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                RubyCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }
    }

    class ClassOnlyAction
    extends Action {
        public ClassOnlyAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.go_into_top_level_type_action");
            this.setText(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_label);
            this.setToolTipText(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_tooltip);
            this.setDescription(RubyEditorMessages.RubyOutlinePage_GoIntoTopLevelType_description);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "gointo_toplevel_type.gif");
            IPreferenceStore preferenceStore = RubyPlugin.getDefault().getPreferenceStore();
            boolean showclass = preferenceStore.getBoolean("GoIntoTopLevelTypeAction.isChecked");
            this.setTopLevelTypeOnly(showclass);
        }

        public void run() {
            this.setTopLevelTypeOnly(!RubyOutlinePage.this.fTopLevelTypeOnly);
        }

        private void setTopLevelTypeOnly(boolean show) {
            RubyOutlinePage.this.fTopLevelTypeOnly = show;
            this.setChecked(show);
            RubyOutlinePage.this.fOutlineViewer.refresh(false);
            IPreferenceStore preferenceStore = RubyPlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue("GoIntoTopLevelTypeAction.isChecked", show);
        }
    }

    class ElementChangedListener
    implements IElementChangedListener {
        ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            if (RubyOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = RubyOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(){

                    public void run() {
                        IRubyScript cu;
                        IRubyScript base = cu = (IRubyScript)RubyOutlinePage.this.fInput;
                        if (RubyOutlinePage.this.fTopLevelTypeOnly && (base = RubyOutlinePage.this.getMainType(cu)) == null) {
                            if (RubyOutlinePage.this.fOutlineViewer != null) {
                                RubyOutlinePage.this.fOutlineViewer.refresh(true);
                            }
                            return;
                        }
                        IRubyElementDelta delta = ElementChangedListener.this.findElement((IRubyElement)base, e.getDelta());
                        if (delta != null && RubyOutlinePage.this.fOutlineViewer != null) {
                            RubyOutlinePage.this.fOutlineViewer.reconcile(delta);
                        }
                    }
                });
            }
        }

        private boolean isPossibleStructuralChange(IRubyElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }

        protected IRubyElementDelta findElement(IRubyElement unit, IRubyElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IRubyElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            IRubyElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IRubyElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        private EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class LexicalSortingAction
    extends Action {
        private RubyElementSorter fSorter = new RubyElementSorter();

        public LexicalSortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.lexical_sorting_outline_action");
            this.setText(RubyEditorMessages.RubyOutlinePage_Sort_label);
            RubyPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.setToolTipText(RubyEditorMessages.RubyOutlinePage_Sort_tooltip);
            this.setDescription(RubyEditorMessages.RubyOutlinePage_Sort_description);
            boolean checked = RubyPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)RubyOutlinePage.this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    RubyOutlinePage.this.fOutlineViewer.setSorter(on ? LexicalSortingAction.this.fSorter : null);
                }
            });
            if (store) {
                RubyPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }

    static class NoClassElement
    extends WorkbenchAdapter
    implements IAdaptable {
        NoClassElement() {
        }

        public String toString() {
            return RubyEditorMessages.RubyOutlinePage_error_NoTopLevelType;
        }

        public Object getAdapter(Class clas) {
            if (clas == IWorkbenchAdapter.class) {
                return this;
            }
            return null;
        }
    }

    class RubyOutlineViewer
    extends TreeViewer {
        private Item fReusedExpandedItem;
        private boolean fReorderedMembers;
        private boolean fForceFireSelectionChanged;

        public RubyOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
            this.setUseHashlookup(true);
        }

        public void reconcile(IRubyElementDelta delta) {
            this.fReorderedMembers = false;
            this.fForceFireSelectionChanged = false;
            if (this.getSorter() == null) {
                if (RubyOutlinePage.this.fTopLevelTypeOnly && delta.getElement() instanceof IType && (delta.getKind() & 1) != 0) {
                    this.refresh(true);
                } else {
                    Widget w;
                    if (RubyOutlinePage.this.fInput instanceof IRubyScript) {
                        try {
                            IRubyScript script = (IRubyScript)RubyOutlinePage.this.fInput;
                            boolean hasChildren = script.hasChildren();
                            if (!hasChildren) {
                                return;
                            }
                        }
                        catch (RubyModelException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((w = this.findItem(RubyOutlinePage.this.fInput)) != null && !w.isDisposed()) {
                        this.update(w, delta);
                    }
                    if (this.fForceFireSelectionChanged) {
                        this.fireSelectionChanged(new SelectionChangedEvent(RubyOutlinePage.this.getSite().getSelectionProvider(), this.getSelection()));
                    }
                    if (this.fReorderedMembers) {
                        this.refresh(false);
                        this.fReorderedMembers = false;
                    }
                }
            } else {
                this.refresh(true);
            }
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IRubyElement je;
            Item i;
            if (node instanceof Item && (i = (Item)node).getData() instanceof IRubyElement && ((je = (IRubyElement)i.getData()).getElementType() == 16 || je.getElementType() == 6) && i != this.fReusedExpandedItem) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        protected void reuseTreeItem(Item item, Object element) {
            Item[] c = this.getChildren((Widget)item);
            if (c != null && c.length > 0) {
                if (this.getExpanded(item)) {
                    this.fReusedExpandedItem = item;
                }
                int k = 0;
                while (k < c.length) {
                    if (c[k].getData() != null) {
                        this.disassociate(c[k]);
                    }
                    c[k].dispose();
                    ++k;
                }
            }
            this.updateItem((Widget)item, element);
            this.updatePlus(item, element);
            this.internalExpandToLevel((Widget)item, -1);
            this.fReusedExpandedItem = null;
            this.fForceFireSelectionChanged = true;
        }

        protected boolean mustUpdateParent(IRubyElementDelta delta, IRubyElement element) {
            return false;
        }

        public boolean isExpandable(Object element) {
            if (this.hasFilters()) {
                return this.getFilteredChildren(element).length > 0;
            }
            return super.isExpandable(element);
        }

        protected ISourceRange getSourceRange(IRubyElement element) throws RubyModelException {
            if (element instanceof ISourceReference) {
                return ((ISourceReference)element).getSourceRange();
            }
            if (element instanceof IMember) {
                return ((IMember)element).getNameRange();
            }
            return null;
        }

        protected boolean overlaps(ISourceRange range, int start, int end) {
            return start <= range.getOffset() + range.getLength() - 1 && range.getOffset() <= end;
        }

        protected boolean filtered(IRubyElement parent, IRubyElement child) {
            Object[] result = new Object[]{child};
            ViewerFilter[] filters = this.getFilters();
            int i = 0;
            while (i < filters.length) {
                if ((result = filters[i].filter((Viewer)this, (Object)parent, result)).length == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        protected void update(Widget w, IRubyElementDelta delta) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            IResource resource;
            this.getInput();
            Object[] changed = event.getElements();
            if (changed != null && (resource = this.getUnderlyingResource()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (changed[i] != null && changed[i].equals(resource)) {
                        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource());
                        break;
                    }
                    ++i;
                }
            }
            super.handleLabelProviderChanged(event);
        }

        private IResource getUnderlyingResource() {
            Object input = this.getInput();
            if (input instanceof IRubyScript) {
                IRubyScript cu = (IRubyScript)input;
                cu = RubyModelUtil.toOriginal(cu);
                return cu.getResource();
            }
            return null;
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        RubyOutlinePage fRubyOutlinePage;

        public ToggleLinkingAction(RubyOutlinePage outlinePage) {
            boolean isLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.SyncOutlineOnCursorMove");
            this.setChecked(isLinkingEnabled);
            this.fRubyOutlinePage = outlinePage;
        }

        public void run() {
            PreferenceConstants.getPreferenceStore().setValue("RubyEditor.SyncOutlineOnCursorMove", this.isChecked());
            if (this.isChecked() && RubyOutlinePage.this.fEditor != null) {
                RubyOutlinePage.this.fEditor.synchronizeOutlinePage(RubyOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
        }
    }
}

