/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

class StringSubstitutionConverter
implements RubyEditor.ITextConverter {
    private ILineTracker fLineTracker;
    private RubyEditor editor;

    public StringSubstitutionConverter(RubyEditor rubyEditor) {
        this.editor = rubyEditor;
    }

    public void setLineTracker(ILineTracker lineTracker) {
        this.fLineTracker = lineTracker;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        String textSelected = "";
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelect = (ITextSelection)selection;
            textSelected = textSelect.getText();
        }
        if (textSelected == null || textSelected.trim().length() == 0) {
            return;
        }
        if (text.equals("#")) {
            this.doStringSubstitution(document, command, textSelected);
            return;
        }
        if (text.equals("'") || text.equals("\"") || text.equals("`")) {
            this.doStringWrapping(document, command, textSelected);
            return;
        }
    }

    private void doStringSubstitution(IDocument document, DocumentCommand command, String textSelected) {
        this.fLineTracker.set(command.text);
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___ruby_partitioning", (int)command.offset, (boolean)true);
            if (!partition.getType().equals("__ruby_string") && !partition.getType().equals("__ruby_command")) {
                return;
            }
            command.text = "#{" + textSelected + "}";
        }
        catch (BadLocationException badLocationException) {}
    }

    private void doStringWrapping(IDocument document, DocumentCommand command, String textSelected) {
        String character = command.text;
        this.fLineTracker.set(command.text);
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___ruby_partitioning", (int)command.offset, (boolean)true);
            if (partition.getType().equals("__ruby_string") || partition.getType().equals("__ruby_command")) {
                return;
            }
            command.text = String.valueOf(character) + textSelected + character;
        }
        catch (BadLocationException badLocationException) {}
    }
}

