/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.search.OccurrencesSearchLabelProvider;
import org.rubypeople.rdt.internal.ui.search.RubyElementLine;
import org.rubypeople.rdt.internal.ui.search.RubyElementLineSorter;
import org.rubypeople.rdt.internal.ui.search.TextSearchTableContentProvider;

public class OccurrencesSearchResultPage
extends AbstractTextSearchViewPage {
    private TextSearchTableContentProvider fContentProvider;

    public OccurrencesSearchResultPage() {
        super(1);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IEditorPart editor = null;
        RubyElementLine element = (RubyElementLine)match.getElement();
        IRubyElement javaElement = element.getRubyElement();
        try {
            editor = EditorUtility.openInEditor(javaElement, false);
        }
        catch (PartInitException partInitException) {
            return;
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(currentOffset, currentLength);
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setSorter((ViewerSorter)new RubyElementLineSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new OccurrencesSearchLabelProvider(this));
        this.fContentProvider = new TextSearchTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }
}

