/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class PatternStrings {
    public static String getSignature(IRubyElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 6: {
                return PatternStrings.getMethodSignature((IMethod)element);
            }
            case 5: {
                return PatternStrings.getTypeSignature((IType)element);
            }
            case 15: {
                return PatternStrings.getFieldSignature((IField)element);
            }
        }
        return element.getElementName();
    }

    public static String getMethodSignature(IMethod method) {
        boolean isConstructor;
        StringBuffer buffer = new StringBuffer();
        if (method.isSingleton() || method.isConstructor()) {
            buffer.append(RubyElementLabels.getElementLabel((IRubyElement)method.getDeclaringType(), 0x1000000000000L));
            buffer.append('.');
        }
        if (!(isConstructor = method.isConstructor())) {
            buffer.append(PatternStrings.getUnqualifiedMethodSignature(method, !isConstructor));
        } else {
            buffer.append("new");
        }
        return buffer.toString();
    }

    private static String getUnqualifiedMethodSignature(IMethod method, boolean isNotConstructor) {
        StringBuffer buffer = new StringBuffer();
        if (isNotConstructor) {
            buffer.append(method.getElementName());
        }
        return buffer.toString();
    }

    public static String getUnqualifiedMethodSignature(IMethod method) {
        return PatternStrings.getUnqualifiedMethodSignature(method, true);
    }

    public static String getTypeSignature(IType field) {
        return RubyElementLabels.getElementLabel((IRubyElement)field, 0x1000000000000L);
    }

    public static String getFieldSignature(IField field) {
        return RubyElementLabels.getElementLabel((IRubyElement)field, 0L);
    }
}

