/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.search.LevelTreeContentProvider;
import org.rubypeople.rdt.internal.ui.search.RubySearchResultPage;
import org.rubypeople.rdt.internal.ui.search.SearchLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class PostfixLabelProvider
extends SearchLabelProvider {
    private ITreeContentProvider fContentProvider = new LevelTreeContentProvider.FastRubyElementProvider();

    public PostfixLabelProvider(RubySearchResultPage page) {
        super(page);
    }

    public Image getImage(Object element) {
        Image image = super.getImage(element);
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    public String getText(Object element) {
        String labelWithCounts = this.getLabelWithCounts(element, this.internalGetText(element));
        StringBuffer res = new StringBuffer(labelWithCounts);
        ITreeContentProvider provider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.fContentProvider.getParent(element);
        Object lastElement = element;
        while (realParent != null && !(realParent instanceof IRubyModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                res.append(RubyElementLabels.CONCAT_STRING).append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.fContentProvider.getParent(realParent);
        }
        return res.toString();
    }

    protected boolean hasChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String internalGetText(Object element) {
        String text = super.getText(element);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getParticipantText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof IRubyScript && type.getRubyScript().equals(realParent)) {
                return true;
            }
        }
        return false;
    }
}

