/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.internal.ui.launchConfigurations.WorkingSetComparator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.RubyUI;

public class RubySearchScopeFactory {
    private static RubySearchScopeFactory fgInstance;
    private final IRubySearchScope EMPTY_SCOPE = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[0]);

    private RubySearchScopeFactory() {
    }

    public static RubySearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new RubySearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws RubyModelException {
        IWorkingSet[] workingSets;
        Shell shell = RubyPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    public IRubySearchScope createRubySearchScope(IWorkingSet[] workingSets, boolean includeRubyVMLibraries) {
        if (workingSets == null || workingSets.length < 1) {
            return this.EMPTY_SCOPE;
        }
        HashSet rubyElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
                return this.createWorkspaceScope(includeRubyVMLibraries);
            }
            this.addRubyElements(rubyElements, workingSet);
            ++i;
        }
        return this.createRubySearchScope(rubyElements, includeRubyVMLibraries);
    }

    public IRubySearchScope createRubySearchScope(IWorkingSet workingSet, boolean includeRubyVMLibraries) {
        HashSet rubyElements = new HashSet(10);
        if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
            return this.createWorkspaceScope(includeRubyVMLibraries);
        }
        this.addRubyElements(rubyElements, workingSet);
        return this.createRubySearchScope(rubyElements, includeRubyVMLibraries);
    }

    public IRubySearchScope createRubySearchScope(IResource[] resources, boolean includeRubyVMLibraries) {
        if (resources == null) {
            return this.EMPTY_SCOPE;
        }
        HashSet rubyElements = new HashSet(resources.length);
        this.addRubyElements(rubyElements, resources);
        return this.createRubySearchScope(rubyElements, includeRubyVMLibraries);
    }

    public IRubySearchScope createRubySearchScope(ISelection selection, boolean includeRubyVMLibraries) {
        return this.createRubySearchScope(this.getRubyElements(selection), includeRubyVMLibraries);
    }

    public IRubySearchScope createRubyProjectSearchScope(String[] projectNames, boolean includeRubyVMLibraries) {
        ArrayList<IRubyProject> res = new ArrayList<IRubyProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < projectNames.length) {
            IRubyProject project = RubyCore.create((IProject)root.getProject(projectNames[i]));
            if (project.exists()) {
                res.add(project);
            }
            ++i;
        }
        return this.createRubySearchScope(res, includeRubyVMLibraries);
    }

    public IRubySearchScope createRubyProjectSearchScope(IRubyProject project, boolean includeRubyVMLibraries) {
        return SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{project}, (int)RubySearchScopeFactory.getSearchFlags(includeRubyVMLibraries));
    }

    public IRubySearchScope createRubyProjectSearchScope(IEditorInput editorInput, boolean includeRubyVMLibraries) {
        IRubyProject project;
        IRubyElement elem = RubyUI.getEditorInputRubyElement(editorInput);
        if (elem != null && (project = elem.getRubyProject()) != null) {
            return this.createRubyProjectSearchScope(project, includeRubyVMLibraries);
        }
        return this.EMPTY_SCOPE;
    }

    public String getWorkspaceScopeDescription(boolean includeRubyVMLibraries) {
        return includeRubyVMLibraries ? SearchMessages.WorkspaceScope : SearchMessages.WorkspaceScopeNoJRE;
    }

    public String getProjectScopeDescription(String[] projectNames, boolean includeRubyVMLibraries) {
        String scopeDescription;
        if (projectNames.length == 0) {
            return SearchMessages.RubySearchScopeFactory_undefined_projects;
        }
        if (projectNames.length == 1) {
            String label = includeRubyVMLibraries ? SearchMessages.EnclosingProjectScope : SearchMessages.EnclosingProjectScopeNoJRE;
            scopeDescription = Messages.format((String)label, (String)projectNames[0]);
        } else if (projectNames.length == 2) {
            String label = includeRubyVMLibraries ? SearchMessages.EnclosingProjectsScope2 : SearchMessages.EnclosingProjectsScope2NoJRE;
            scopeDescription = Messages.format((String)label, (Object[])new String[]{projectNames[0], projectNames[1]});
        } else {
            String label = includeRubyVMLibraries ? SearchMessages.EnclosingProjectsScope : SearchMessages.EnclosingProjectsScopeNoJRE;
            scopeDescription = Messages.format((String)label, (Object[])new String[]{projectNames[0], projectNames[1]});
        }
        return scopeDescription;
    }

    public String getProjectScopeDescription(IRubyProject project, boolean includeRubyVMLibraries) {
        if (includeRubyVMLibraries) {
            return Messages.format((String)SearchMessages.ProjectScope, (String)project.getElementName());
        }
        return Messages.format((String)SearchMessages.ProjectScopeNoJRE, (String)project.getElementName());
    }

    public String getProjectScopeDescription(IEditorInput editorInput, boolean includeRubyVMLibraries) {
        IRubyProject project;
        IRubyElement elem = RubyUI.getEditorInputRubyElement(editorInput);
        if (elem != null && (project = elem.getRubyProject()) != null) {
            return this.getProjectScopeDescription(project, includeRubyVMLibraries);
        }
        return Messages.format((String)SearchMessages.ProjectScope, (String)"");
    }

    public String getHierarchyScopeDescription(IType type) {
        return Messages.format((String)SearchMessages.HierarchyScope, (Object[])new String[]{type.getElementName()});
    }

    public String getSelectionScopeDescription(IRubyElement[] rubyElements, boolean includeRubyVMLibraries) {
        String scopeDescription;
        if (rubyElements.length == 0) {
            return SearchMessages.RubySearchScopeFactory_undefined_selection;
        }
        if (rubyElements.length == 1) {
            String label = includeRubyVMLibraries ? SearchMessages.SingleSelectionScope : SearchMessages.SingleSelectionScopeNoJRE;
            scopeDescription = Messages.format((String)label, (String)rubyElements[0].getElementName());
        } else if (rubyElements.length == 1) {
            String label = includeRubyVMLibraries ? SearchMessages.DoubleSelectionScope : SearchMessages.DoubleSelectionScopeNoJRE;
            scopeDescription = Messages.format((String)label, (Object[])new String[]{rubyElements[0].getElementName(), rubyElements[1].getElementName()});
        } else {
            String label = includeRubyVMLibraries ? SearchMessages.SelectionScope : SearchMessages.SelectionScopeNoJRE;
            scopeDescription = Messages.format((String)label, (Object[])new String[]{rubyElements[0].getElementName(), rubyElements[1].getElementName()});
        }
        return scopeDescription;
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] workingSets, boolean includeRubyVMLibraries) {
        if (workingSets.length == 0) {
            return SearchMessages.RubySearchScopeFactory_undefined_workingsets;
        }
        if (workingSets.length == 1) {
            String label = includeRubyVMLibraries ? SearchMessages.SingleWorkingSetScope : SearchMessages.SingleWorkingSetScopeNoJRE;
            return Messages.format((String)label, (String)workingSets[0].getLabel());
        }
        Arrays.sort(workingSets, new WorkingSetComparator());
        if (workingSets.length == 2) {
            String label = includeRubyVMLibraries ? SearchMessages.DoubleWorkingSetScope : SearchMessages.DoubleWorkingSetScopeNoJRE;
            return Messages.format((String)label, (Object[])new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        }
        String label = includeRubyVMLibraries ? SearchMessages.WorkingSetsScope : SearchMessages.WorkingSetsScopeNoJRE;
        return Messages.format((String)label, (Object[])new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
    }

    public IProject[] getProjects(IRubySearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndJars();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    public IRubyElement[] getRubyElements(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return this.getRubyElements(((IStructuredSelection)selection).toArray());
        }
        return new IRubyElement[0];
    }

    private IRubyElement[] getRubyElements(Object[] elements) {
        if (elements.length == 0) {
            return new IRubyElement[0];
        }
        HashSet result = new HashSet(elements.length);
        int i = 0;
        while (i < elements.length) {
            IResource resource;
            Object selectedElement = elements[i];
            if (selectedElement instanceof IRubyElement) {
                this.addRubyElements(result, (IRubyElement)selectedElement);
            } else if (selectedElement instanceof IResource) {
                this.addRubyElements(result, (IResource)selectedElement);
            } else if (selectedElement instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)selectedElement;
                this.addRubyElements(result, ws);
            } else if (selectedElement instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedElement).getAdapter(IResource.class)) != null) {
                this.addRubyElements(result, resource);
            }
            ++i;
        }
        return result.toArray(new IRubyElement[result.size()]);
    }

    public IRubySearchScope createRubySearchScope(IRubyElement[] rubyElements, boolean includeRubyVMLibraries) {
        if (rubyElements.length == 0) {
            return this.EMPTY_SCOPE;
        }
        return SearchEngine.createRubySearchScope((IRubyElement[])rubyElements, (int)RubySearchScopeFactory.getSearchFlags(includeRubyVMLibraries));
    }

    private IRubySearchScope createRubySearchScope(Collection rubyElements, boolean includeRubyVMLibraries) {
        if (rubyElements.isEmpty()) {
            return this.EMPTY_SCOPE;
        }
        IRubyElement[] elementArray = rubyElements.toArray(new IRubyElement[rubyElements.size()]);
        return SearchEngine.createRubySearchScope((IRubyElement[])elementArray, (int)RubySearchScopeFactory.getSearchFlags(includeRubyVMLibraries));
    }

    private static int getSearchFlags(boolean includeRubyVMLibraries) {
        int flags = 3;
        if (includeRubyVMLibraries) {
            flags |= 4;
        }
        return flags;
    }

    private void addRubyElements(Set rubyElements, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addRubyElements(rubyElements, resources[i]);
            ++i;
        }
    }

    private void addRubyElements(Set rubyElements, IResource resource) {
        IRubyElement javaElement = (IRubyElement)resource.getAdapter(IRubyElement.class);
        if (javaElement == null) {
            return;
        }
        if (javaElement.getElementType() == 3) {
            try {
                this.addRubyElements(rubyElements, ((IFolder)resource).members());
            }
            catch (CoreException coreException) {}
        }
        rubyElements.add(javaElement);
    }

    private void addRubyElements(Set rubyElements, IRubyElement rubyElement) {
        rubyElements.add(rubyElement);
    }

    private void addRubyElements(Set rubyElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
            try {
                IRubyProject[] projects = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getRubyProjects();
                rubyElements.addAll((Collection)Arrays.asList(projects));
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IRubyElement rubyElement = (IRubyElement)elements[i].getAdapter(IRubyElement.class);
            if (rubyElement != null) {
                this.addRubyElements(rubyElements, rubyElement);
            } else {
                IResource resource = (IResource)elements[i].getAdapter(IResource.class);
                if (resource != null) {
                    this.addRubyElements(rubyElements, resource);
                }
            }
            ++i;
        }
    }

    public IRubySearchScope createWorkspaceScope(boolean includeRubyVMLibraries) {
        if (!includeRubyVMLibraries) {
            try {
                IRubyProject[] projects = RubyCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getRubyProjects();
                return SearchEngine.createRubySearchScope((IRubyElement[])projects, (int)RubySearchScopeFactory.getSearchFlags(includeRubyVMLibraries));
            }
            catch (RubyModelException rubyModelException) {}
        }
        return SearchEngine.createWorkspaceScope();
    }

    public boolean isInsideRubyVMLibraries(IRubyElement element) {
        ISourceFolderRoot root = (ISourceFolderRoot)element.getAncestor(2);
        if (root != null) {
            try {
                ILoadpathEntry entry = root.getRawLoadpathEntry();
                if (entry.getEntryKind() == 5) {
                    ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)root.getRubyProject());
                    return container != null && container.getKind() == 3;
                }
                return false;
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
        return true;
    }
}

