/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.io.EOFException;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class DocumentationCommentRule
extends MultiLineRule {
    private static final String endSequence = "=end";

    public DocumentationCommentRule(IToken token) {
        super("=begin", "", token);
        this.setColumnConstraint(0);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        if (scanner.getColumn() != 0) {
            return false;
        }
        String line = "";
        do {
            try {
                line = this.readLine(scanner);
            }
            catch (EOFException eOFException) {
                return true;
            }
        } while (!endSequence.equals(line));
        return true;
    }

    private String readLine(ICharacterScanner scanner) throws EOFException {
        int c;
        StringBuffer line = new StringBuffer();
        while ((char)(c = scanner.read()) != '\n' && (char)c != '\r') {
            if (c == -1) {
                throw new EOFException();
            }
            line.append((char)c);
        }
        return line.toString();
    }
}

