/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.CompositeReconcilingStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.IProblemRequestorExtension;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyReconcilingStrategy;
import org.rubypeople.rdt.internal.ui.text.spelling.RubySpellingReconcileStrategy;

public class RubyCompositeReconcilingStrategy
extends CompositeReconcilingStrategy {
    private ITextEditor fEditor;
    private RubyReconcilingStrategy fRubyStrategy;

    public RubyCompositeReconcilingStrategy(ITextEditor editor, String documentPartitioning) {
        this.fEditor = editor;
        this.fRubyStrategy = new RubyReconcilingStrategy(editor);
        this.setReconcilingStrategies(new IReconcilingStrategy[]{this.fRubyStrategy, new RubySpellingReconcileStrategy(editor)});
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel m;
        IDocumentProvider p = this.fEditor.getDocumentProvider();
        if (p == null) {
            p = RubyPlugin.getDefault().getRubyDocumentProvider();
        }
        if ((m = p.getAnnotationModel((Object)this.fEditor.getEditorInput())) instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)m;
        }
        return null;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(dirtyRegion, subRegion);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.reconcile(partition);
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.reconcile(partition);
        }
    }

    public void notifyListeners(boolean notify) {
        this.fRubyStrategy.notifyListeners(notify);
    }

    public void initialReconcile() {
        IProblemRequestorExtension e = this.getProblemRequestorExtension();
        if (e != null) {
            try {
                e.beginReportingSequence();
                super.initialReconcile();
            }
            finally {
                e.endReportingSequence();
            }
        } else {
            super.initialReconcile();
        }
    }

    public void aboutToBeReconciled() {
        this.fRubyStrategy.aboutToBeReconciled();
    }
}

