/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;

public class RubyIndenter {
    private IDocument fDocument;
    private IRubyProject fProject;
    private RubyHeuristicScanner fScanner;

    public RubyIndenter(IDocument d, RubyHeuristicScanner scanner, IRubyProject project) {
        this.fDocument = d;
        this.fScanner = scanner;
        this.fProject = project;
    }

    public StringBuffer computeIndentation(int offset) {
        StringBuffer buf = this.getLeadingWhitespace(offset);
        return buf;
    }

    private StringBuffer getLeadingWhitespace(int offset) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            if (nonWS == -1) {
                indent.append(this.fDocument.get(lineOffset, line.getLength()));
                return indent;
            }
            indent.append(this.fDocument.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }
}

