/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.jruby.ast.BeginNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;

public class RubyPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;

    public RubyPairMatcher(char[] pairs) {
        this.fPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        if (this.fDocument != null && this.matchBlocksAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    private boolean matchBlocksAt() {
        Node root;
        this.fStartPos = -1;
        this.fEndPos = -1;
        String src = this.fDocument.get();
        if (src.length() == 0) {
            return false;
        }
        try {
            RubyParser parser = new RubyParser();
            root = parser.parse(src).getAST();
        }
        catch (SyntaxException syntaxException) {
            return false;
        }
        catch (RuntimeException e) {
            RubyPlugin.log(e);
            return false;
        }
        Node spanning = ClosestSpanningNodeLocator.Instance().findClosestSpanner(root, this.fOffset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (node instanceof IfNode) {
                    IfNode cfr_ignored_0 = (IfNode)node;
                }
                return node instanceof ModuleNode || node instanceof SClassNode || node instanceof ClassNode || node instanceof DefnNode || node instanceof DefsNode || node instanceof BeginNode || node instanceof WhileNode || node instanceof CaseNode || node instanceof ForNode || node instanceof IfNode || node instanceof IterNode;
            }
        });
        if (spanning == null) {
            return false;
        }
        if (!this.isOnEnd(spanning) && !this.isOnBeginning(spanning)) {
            return false;
        }
        this.fAnchor = this.isOnEnd(spanning) ? 0 : 1;
        this.fStartPos = spanning.getPosition().getStartOffset();
        this.fEndPos = spanning.getPosition().getEndOffset();
        if (src.length() == this.fEndPos) {
            --this.fEndPos;
        }
        return true;
    }

    private boolean isOnBeginning(Node spanning) {
        return this.fOffset >= spanning.getPosition().getStartOffset() && this.fOffset <= spanning.getPosition().getStartOffset() + this.getKeywordLength(spanning);
    }

    private boolean isOnEnd(Node spanning) {
        return this.fOffset >= spanning.getPosition().getEndOffset() - 4 && this.fOffset <= spanning.getPosition().getEndOffset();
    }

    private int getKeywordLength(Node spanning) {
        if (spanning instanceof ClassNode || spanning instanceof BeginNode || spanning instanceof WhileNode) {
            return 5;
        }
        if (spanning instanceof DefnNode || spanning instanceof DefsNode || spanning instanceof ForNode) {
            return 3;
        }
        if (spanning instanceof WhenNode) {
            return 4;
        }
        if (spanning instanceof ModuleNode) {
            return 6;
        }
        if (spanning instanceof IfNode || spanning instanceof IterNode) {
            return 2;
        }
        return 1;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchPairsAt() {
        int pairIndex1 = this.fPairs.length;
        int pairIndex2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char prevChar = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[pairIndex2 - 1], this.fPairs[pairIndex2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
                return false;
            }
            if (this.fStartPos <= -1) return false;
            this.fAnchor = 1;
            this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[pairIndex1], this.fPairs[pairIndex1 + 1], this.fDocument);
            if (this.fEndPos > -1) {
                return true;
            }
            this.fStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected int searchForClosingPeer(int offset, char openingPeer, char closingPeer, IDocument document) throws BadLocationException {
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(document, "___ruby_partitioning", TextUtilities.getContentType((IDocument)document, (String)"___ruby_partitioning", (int)offset, (boolean)false));
        return scanner.findClosingPeer(offset + 1, openingPeer, closingPeer);
    }

    protected int searchForOpeningPeer(int offset, char openingPeer, char closingPeer, IDocument document) throws BadLocationException {
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(document, "___ruby_partitioning", TextUtilities.getContentType((IDocument)document, (String)"___ruby_partitioning", (int)offset, (boolean)false));
        int peer = scanner.findOpeningPeer(offset - 1, openingPeer, closingPeer);
        if (peer == -1) {
            return -1;
        }
        return peer;
    }
}

