/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jruby.CompatVersion;
import org.jruby.ast.CommentNode;
import org.jruby.ast.Node;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.KCode;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyPartitionScanner
implements IPartitionTokenScanner {
    private static final String BEGIN = "=begin";
    private RubyYaccLexer lexer;
    private ParserSupport parserSupport;
    private RubyParserResult result;
    private String fContents;
    private LexerSource lexerSource;
    private int origOffset;
    private int origLength;
    private int fLength;
    private int fOffset;
    private List<QueuedToken> fQueue = new ArrayList<QueuedToken>();
    private String fContentType = "__dftl_partition_content_type";
    private boolean inSingleQuote;
    private String fOpeningString;
    public static final String RUBY_MULTI_LINE_COMMENT = "__ruby_multiline_comment";
    public static final String RUBY_SINGLE_LINE_COMMENT = "__ruby_singleline_comment";
    public static final String RUBY_STRING = "__ruby_string";
    public static final String RUBY_REGULAR_EXPRESSION = "__ruby_regular_expression";
    public static final String RUBY_DEFAULT = "__dftl_partition_content_type";
    public static final String RUBY_COMMAND = "__ruby_command";
    public static final String[] LEGAL_CONTENT_TYPES = new String[]{"__dftl_partition_content_type", "__ruby_multiline_comment", "__ruby_singleline_comment", "__ruby_regular_expression", "__ruby_string", "__ruby_command"};

    public RubyPartitionScanner() {
        this.lexer = new RubyYaccLexer();
        this.parserSupport = new ParserSupport();
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, false, CompatVersion.RUBY1_8);
        config.setExtraPositionInformation(true);
        this.parserSupport.setConfiguration(config);
        this.result = new RubyParserResult();
        this.parserSupport.setResult(this.result);
        this.lexer.setParserSupport(this.parserSupport);
        this.lexer.setWarnings((IRubyWarnings)new NullWarnings());
        this.lexer.setEncoding(config.getKCode().getEncoding());
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.reset();
        int myOffset = offset;
        if (contentType != null) {
            int diff = offset - partitionOffset;
            myOffset = partitionOffset;
            length += diff;
        }
        if (myOffset == -1) {
            myOffset = 0;
        }
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        try {
            this.fContents = document.get(myOffset, length);
            if (this.fContents.startsWith("}") && offset > 1 && this.fContents.length() >= 2) {
                this.fContents = "\"" + this.fContents.substring(1);
            }
            this.lexerSource = LexerSource.getSource((String)"filename", (Reader)new StringReader(this.fContents), null, (ParserConfiguration)config);
            this.lexer.setSource(this.lexerSource);
        }
        catch (BadLocationException badLocationException) {
            this.lexerSource = LexerSource.getSource((String)"filename", (Reader)new StringReader(""), null, (ParserConfiguration)config);
            this.lexer.setSource(this.lexerSource);
        }
        this.origOffset = myOffset;
        this.origLength = length;
    }

    private void reset() {
        this.lexer.reset();
        this.lexer.setState(RubyYaccLexer.LexState.EXPR_BEG);
        this.parserSupport.initTopLocalVariables();
        this.fQueue.clear();
        this.inSingleQuote = false;
    }

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken() {
        boolean isEOF;
        Token returnValue;
        block17: {
            SyntaxException se2;
            block18: {
                QueuedToken qtoken;
                int length;
                int start;
                block19: {
                    IToken token;
                    RubyPartitionScanner scanner;
                    if (!this.fQueue.isEmpty()) {
                        return this.popTokenOffQueue();
                    }
                    this.fOffset = this.getOffset();
                    this.fLength = 0;
                    returnValue = new Token((Object)RUBY_DEFAULT);
                    isEOF = false;
                    try {
                        boolean bl = isEOF = !this.lexer.advance();
                        if (isEOF) {
                            returnValue = Token.EOF;
                        } else {
                            int lexerToken = this.lexer.token();
                            if (!this.inSingleQuote && lexerToken == 371) {
                                this.addPoundToken();
                                this.scanDynamicVariable();
                                this.setLexerPastDynamicSectionOfString();
                                return this.popTokenOffQueue();
                            }
                            if (!this.inSingleQuote && lexerToken == 370) {
                                this.addPoundBraceToken();
                                this.scanTokensInsideDynamicPortion();
                                this.addClosingBraceToken();
                                this.setLexerPastDynamicSectionOfString();
                                return this.popTokenOffQueue();
                            }
                            if (lexerToken == 365) {
                                String opening = this.getOpeningString();
                                int index = this.indexOf(opening, ", +");
                                if (opening.trim().startsWith("<<") && index != -1) {
                                    this.addHereDocStartToken(index);
                                    this.addCommaToken(index);
                                    this.scanRestOfLine(opening, index);
                                    this.fOpeningString = String.valueOf(opening.substring(0, index).trim()) + "\n";
                                    this.fContentType = RUBY_STRING;
                                    return this.popTokenOffQueue();
                                }
                            }
                            returnValue = this.getToken(lexerToken);
                        }
                        List comments = this.result.getCommentNodes();
                        if (comments != null && !comments.isEmpty()) {
                            this.parseOutComments(comments);
                            this.addQueuedToken((IToken)returnValue, isEOF);
                            comments.clear();
                            return this.popTokenOffQueue();
                        }
                        break block17;
                    }
                    catch (SyntaxException se2) {
                        if (!se2.getMessage().equals("embedded document meets end of file")) break block18;
                        start = se2.getPosition().getStartOffset();
                        length = this.fContents.length() - start;
                        qtoken = new QueuedToken((IToken)new Token((Object)RUBY_MULTI_LINE_COMMENT), start + this.origOffset, length);
                        if (this.fOffset != this.origOffset) break block19;
                        scanner = new RubyPartitionScanner();
                        String possible = this.fContents.substring(0, start);
                        Document document = new Document(possible);
                        scanner.setRange((IDocument)document, this.origOffset, possible.length());
                    }
                    while (!(token = scanner.nextToken()).isEOF()) {
                        this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
                    }
                }
                this.push(qtoken);
                this.push(new QueuedToken(Token.EOF, start + this.origOffset + length, 0));
                return this.popTokenOffQueue();
                catch (IOException e) {
                    RubyPlugin.log(e);
                    break block17;
                }
            }
            if (se2.getMessage().equals("unterminated string meets end of file")) {
                int start = se2.getPosition().getStartOffset();
                int length = this.fContents.length() - start;
                QueuedToken qtoken = new QueuedToken((IToken)new Token((Object)this.fContentType), start + this.origOffset, length);
                if (this.fOffset == this.origOffset) {
                    IToken token;
                    RubyPartitionScanner scanner = new RubyPartitionScanner();
                    String possible = this.fContents.substring(0, start);
                    Document document = new Document(possible);
                    scanner.setRange((IDocument)document, this.origOffset, possible.length());
                    while (!(token = scanner.nextToken()).isEOF()) {
                        this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
                    }
                }
                this.push(qtoken);
                this.push(new QueuedToken(Token.EOF, start + this.origOffset + length, 0));
                return this.popTokenOffQueue();
            }
            if (this.lexerSource.getOffset() - this.origLength == 0) {
                return Token.EOF;
            }
            this.fLength = this.getOffset() - this.fOffset;
            Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
            return new Token((Object)RUBY_DEFAULT);
        }
        if (!isEOF) {
            this.fLength = this.getOffset() - this.fOffset;
            Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
        }
        return returnValue;
    }

    private int indexOf(String opening, String string) {
        String trimmed = opening.trim();
        int diff = trimmed.length() == 0 ? opening.length() : opening.indexOf(trimmed.charAt(0));
        int lowest = -1;
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            int value = trimmed.indexOf(c);
            if (value != -1) {
                value += diff;
                if (lowest == -1) {
                    lowest = value;
                } else if (value < lowest) {
                    lowest = value;
                }
            }
            ++i;
        }
        return lowest;
    }

    private void scanRestOfLine(String opening, int index) {
        IToken token;
        String possible = opening.substring(index + 1);
        RubyPartitionScanner scanner = new RubyPartitionScanner();
        Document document = new Document(possible);
        scanner.setRange((IDocument)document, 0, possible.length());
        while (!(token = scanner.nextToken()).isEOF()) {
            this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset + index + 1, scanner.getTokenLength()));
        }
        this.setOffset(this.fOffset + index + 1 + possible.length());
    }

    private void addCommaToken(int index) {
        this.push(new QueuedToken((IToken)new Token((Object)RUBY_DEFAULT), this.fOffset + index, 1));
    }

    private void addHereDocStartToken(int index) {
        this.push(new QueuedToken((IToken)new Token((Object)RUBY_STRING), this.fOffset, index));
    }

    private void setOffset(int offset) {
        this.fOffset = offset;
    }

    private void addPoundToken() {
        this.addStringToken(1);
    }

    private void scanDynamicVariable() {
        IToken token;
        int doubleQuote;
        int whitespace = this.fContents.indexOf(32, this.fOffset - this.origOffset);
        if (whitespace == -1) {
            whitespace = Integer.MAX_VALUE;
        }
        if ((doubleQuote = this.fContents.indexOf(34, this.fOffset - this.origOffset)) == -1) {
            doubleQuote = Integer.MAX_VALUE;
        }
        int end = Math.min(whitespace, doubleQuote);
        String possible = null;
        possible = end == -1 ? this.fContents.substring(this.fOffset - this.origOffset) : this.fContents.substring(this.fOffset - this.origOffset, end);
        RubyPartitionScanner scanner = new RubyPartitionScanner();
        Document document = new Document(possible);
        scanner.setRange((IDocument)document, 0, possible.length());
        while (!(token = scanner.nextToken()).isEOF()) {
            this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
        }
        this.setOffset(this.fOffset + possible.length());
    }

    private void scanTokensInsideDynamicPortion() {
        IToken token;
        String possible = new String(this.fContents.substring(this.fOffset - this.origOffset));
        int end = this.findEnd(possible);
        possible = end != -1 ? possible.substring(0, end) : possible.substring(0);
        RubyPartitionScanner scanner = new RubyPartitionScanner();
        Document document = new Document(possible);
        scanner.setRange((IDocument)document, 0, possible.length());
        while (!(token = scanner.nextToken()).isEOF()) {
            this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
        }
        this.setOffset(this.fOffset + possible.length());
    }

    private int findEnd(String possible) {
        return new EndBraceFinder(possible).find();
    }

    private void addPoundBraceToken() {
        this.addStringToken(2);
    }

    private void addStringToken(int length) {
        this.push(new QueuedToken((IToken)new Token((Object)this.fContentType), this.fOffset, length));
        this.setOffset(this.fOffset + length);
    }

    private void addClosingBraceToken() {
        this.addStringToken(1);
    }

    private void setLexerPastDynamicSectionOfString() throws IOException {
        StringBuffer fakeContents = new StringBuffer();
        int start = this.fOffset - this.fOpeningString.length();
        int i = 0;
        while (i < start) {
            fakeContents.append(" ");
            ++i;
        }
        fakeContents.append(this.fOpeningString);
        if (this.fOffset - this.origOffset < this.origLength) {
            fakeContents.append(new String(this.fContents.substring(this.fOffset - this.origOffset)));
        }
        Document document = new Document(fakeContents.toString());
        ArrayList<QueuedToken> queueCopy = new ArrayList<QueuedToken>(this.fQueue);
        this.setPartialRange((IDocument)document, start, fakeContents.length() - start, null, start);
        this.fQueue = new ArrayList<QueuedToken>(queueCopy);
        this.lexer.advance();
    }

    private void parseOutComments(List comments) {
        for (CommentNode comment : comments) {
            int offset = this.correctOffset(comment);
            int length = comment.getContent().length();
            if (this.isCommentMultiLine(comment)) {
                length = this.origOffset + comment.getPosition().getEndOffset() - offset;
                if (comment.getContent().charAt(0) != '=') {
                    ++length;
                }
            }
            Token token = new Token((Object)this.getContentType(comment));
            this.push(new QueuedToken((IToken)token, offset, length));
        }
    }

    private IToken popTokenOffQueue() {
        QueuedToken token = this.fQueue.remove(0);
        this.setOffset(token.getOffset());
        Assert.isTrue((token.getLength() >= 0 ? 1 : 0) != 0);
        this.fLength = token.getLength();
        return token.getToken();
    }

    private IToken getToken(int i) {
        if (i == 32) {
            return new Token((Object)this.fContentType);
        }
        switch (i) {
            case 362: {
                if (this.fOffset == this.origOffset) {
                    this.fOpeningString = "\"";
                    this.fContentType = RUBY_STRING;
                    return new Token((Object)RUBY_STRING);
                }
                return new Token((Object)this.fContentType);
            }
            case 377: {
                return new Token((Object)this.fContentType);
            }
            case 365: {
                this.fOpeningString = this.getOpeningString();
                if (this.fOpeningString.equals("'") || this.fOpeningString.startsWith("%q")) {
                    this.inSingleQuote = true;
                } else if (this.fOpeningString.startsWith("<<")) {
                    this.fOpeningString = String.valueOf(this.fOpeningString) + "\n";
                }
                this.fContentType = RUBY_STRING;
                return new Token((Object)RUBY_STRING);
            }
            case 366: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = RUBY_COMMAND;
                return new Token((Object)RUBY_COMMAND);
            }
            case 368: 
            case 369: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = RUBY_STRING;
                return new Token((Object)RUBY_STRING);
            }
            case 372: {
                String oldContentType = this.fContentType;
                this.fContentType = RUBY_DEFAULT;
                this.inSingleQuote = false;
                return new Token((Object)oldContentType);
            }
            case 367: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = RUBY_REGULAR_EXPRESSION;
                return new Token((Object)RUBY_REGULAR_EXPRESSION);
            }
            case 380: {
                this.fContentType = RUBY_DEFAULT;
                return new Token((Object)RUBY_REGULAR_EXPRESSION);
            }
            case 364: {
                int nextCharOffset = this.fOffset + 2;
                int charAt = nextCharOffset - this.origOffset;
                if (this.fContents.length() <= charAt) {
                    return new Token((Object)RUBY_DEFAULT);
                }
                char c = this.fContents.charAt(charAt);
                if (c == '\"') {
                    this.fOpeningString = "\"";
                    this.push(new QueuedToken((IToken)new Token((Object)RUBY_STRING), nextCharOffset, 1));
                    this.fContentType = RUBY_STRING;
                }
                return new Token((Object)RUBY_DEFAULT);
            }
        }
        return new Token((Object)RUBY_DEFAULT);
    }

    private String getOpeningString() {
        int start = this.fOffset - this.origOffset;
        List comments = this.result.getCommentNodes();
        if (comments != null && !comments.isEmpty()) {
            int end;
            Node comment = (Node)comments.get(comments.size() - 1);
            start = end = comment.getPosition().getEndOffset();
        }
        return this.fContents.substring(start, this.lexerSource.getOffset()).trim();
    }

    private int correctOffset(CommentNode comment) {
        return this.origOffset + comment.getPosition().getStartOffset();
    }

    private boolean isCommentMultiLine(CommentNode comment) {
        String src = ASTUtil.getSource((String)this.fContents, (Node)comment);
        return src != null && src.startsWith(BEGIN);
    }

    private String getContentType(CommentNode comment) {
        if (this.isCommentMultiLine(comment)) {
            return RUBY_MULTI_LINE_COMMENT;
        }
        return RUBY_SINGLE_LINE_COMMENT;
    }

    private void addQueuedToken(IToken returnValue, boolean isEOF) {
        QueuedToken token = this.peek();
        this.setOffset(token.getOffset() + token.getLength());
        int length = this.getOffset() - this.fOffset;
        if (length < 0) {
            length = 0;
        }
        this.push(new QueuedToken(returnValue, this.fOffset, length));
    }

    private QueuedToken peek() {
        return this.fQueue.get(this.fQueue.size() - 1);
    }

    private void push(QueuedToken token) {
        Assert.isTrue((token.getLength() >= 0 ? 1 : 0) != 0);
        this.fQueue.add(token);
    }

    private int getOffset() {
        return this.lexerSource.getOffset() + this.origOffset;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, null, -1);
    }

    public static class EndBraceFinder {
        private String input;
        private List<String> stack;

        public EndBraceFinder(String possible) {
            this.input = possible;
            this.stack = new ArrayList<String>();
        }

        public int find() {
            int i = 0;
            while (i < this.input.length()) {
                char c = this.input.charAt(i);
                switch (c) {
                    case '$': 
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '\"': {
                        if (this.topEquals("\"")) {
                            this.pop();
                            break;
                        }
                        this.push("\"");
                        break;
                    }
                    case '\'': {
                        if (this.topEquals("'")) {
                            this.pop();
                            break;
                        }
                        if (this.topEquals("\"")) break;
                        this.push("'");
                        break;
                    }
                    case '{': {
                        if (this.topEquals("'") || this.topEquals("\"")) break;
                        this.push("{");
                        break;
                    }
                    case '#': {
                        if (!this.topEquals("\"") || (c = this.input.charAt(i + 1)) != '{') break;
                        this.push("#{");
                        break;
                    }
                    case '}': {
                        if (this.stack.isEmpty()) {
                            return i;
                        }
                        if (!this.topEquals("#{") && !this.topEquals("{")) break;
                        this.pop();
                        break;
                    }
                }
                ++i;
            }
            return -1;
        }

        private boolean topEquals(String string) {
            String open = this.peek();
            return open != null && open.equals(string);
        }

        private boolean push(String string) {
            return this.stack.add(string);
        }

        private String pop() {
            return this.stack.remove(this.stack.size() - 1);
        }

        private String peek() {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.get(this.stack.size() - 1);
        }
    }

    private static class QueuedToken {
        private IToken token;
        private int length;
        private int offset;

        QueuedToken(IToken token, int offset, int length) {
            this.token = token;
            this.length = length;
            this.offset = offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public IToken getToken() {
            return this.token;
        }

        public String toString() {
            return this.getToken().getData() + ": offset: " + this.getOffset() + ", length: " + this.getLength();
        }
    }
}

