/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.codemanipulation.StubUtility;
import org.rubypeople.rdt.internal.corext.refactoring.changes.RubyScriptChange;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.text.correction.CorrectionMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.correction.ChangeCorrectionProposal;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private IRubyScript fRubyScript;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, IRubyScript cu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        if (cu == null) {
            throw new IllegalArgumentException("Ruby script must not be null");
        }
        this.fRubyScript = cu;
    }

    protected CUCorrectionProposal(String name, IRubyScript cu, int relevance, Image image) {
        this(name, cu, null, relevance, image);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) throws BadLocationException {
        int startLine = text.getLineOfOffset(startOffset);
        int endLine = text.getLineOfOffset(endOffset);
        boolean dotsAdded = false;
        if (surroundLinesOnly && startOffset == 0) {
            startLine = Math.max(endLine - 1, 0);
            buf.append("...<br>");
            dotsAdded = true;
        }
        int i = startLine;
        while (i <= endLine) {
            if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                if (!dotsAdded) {
                    buf.append("...<br>");
                    dotsAdded = true;
                } else if (endOffset == text.getLength()) {
                    return;
                }
            } else {
                IRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.get(from, to - from);
                if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                    int k = 0;
                    while (k < content.length()) {
                        char ch = content.charAt(k);
                        if (ch == '<') {
                            buf.append("&lt;");
                        } else if (ch == '>') {
                            buf.append("&gt;");
                        } else {
                            buf.append(ch);
                        }
                        ++k;
                    }
                    if (to == end && to != endOffset) {
                        buf.append("<br>");
                    }
                }
            }
            ++i;
        }
    }

    public void apply(IDocument document) {
        try {
            IRubyScript unit = this.getRubyScript();
            IEditorPart part = null;
            if (unit.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(unit);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null && (part = EditorUtility.openInEditor(unit, true)) != null) {
                    document = RubyUI.getDocumentProvider().getDocument((Object)part.getEditorInput());
                }
                if ((page = RubyPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.CUCorrectionProposal_error_title, CorrectionMessages.CUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(IRubyScript unit) {
        IStatus status = Resources.makeCommittable((IResource)unit.getResource(), (Object)RubyPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.CUCorrectionProposal_error_title;
            String message = CorrectionMessages.CUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    protected TextChange createTextChange() throws CoreException {
        RubyScriptChange change;
        Document document;
        IRubyScript cu = this.getRubyScript();
        String name = this.getDisplayString();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IRubyElement)cu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            RubyScriptChange cuChange = new RubyScriptChange(name, cu);
            cuChange.setSaveMode(4);
            change = cuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final IRubyScript getRubyScript() {
        return this.fRubyScript;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }
}

